% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_countSNPs.R
\name{countSNPs}
\alias{countSNPs}
\title{Count pairwise SNPs between aligned DNA sequences}
\usage{
countSNPs(fastaData, deleteGapsGlobally = FALSE)
}
\arguments{
\item{fastaData}{A [Biostrings::DNAStringSet-class] of aligned DNA sequences.
Sequences must have identical width.}

\item{deleteGapsGlobally}{Logical. If `TRUE`, sites containing gaps (`-` or `.`)
or ambiguous bases (`"N"`, `"?"`) are removed across all sequences 
before SNP counting. Default: `FALSE`.}
}
\value{
A square integer matrix of SNP counts with sequence names as 
   row and column dimnames.
}
\description{
Computes the absolute number of single-nucleotide differences (SNPs)
between all pairs of sequences in an aligned
[Biostrings::DNAStringSet-class] object. Optionally removes any
alignment columns that contain gaps or ambiguous bases before counting.
}
\examples{
if (interactive()) {
  aln <- Biostrings::DNAStringSet(c(Seq1="ATGC", Seq2="ATGT", Seq3="ATGA"))
  countSNPs(aln)
  countSNPs(aln, deleteGapsGlobally = FALSE)
}

}
\seealso{
[pairwiseDistances()] for distances; [SNPeek()], [plotAA()] for viz.
}
