% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{plotVolcano}
\alias{plotVolcano}
\title{Function to draw a plot of the pvalues stored in an \code{ExWAS} object}
\usage{
plotVolcano(x, p.value = -log10(0.001), labels, show.effect = FALSE)
}
\arguments{
\item{x}{An \code{ExWAS} object which effect will be ploted.}

\item{p.value}{(default \code{"-log10(0.001)"}) Threshold for P-Value.}

\item{labels}{(optional) Character vector with the labels for each exposure.
It must be labeled vector.}

\item{show.effect}{(default \code{FALSE}) Applyes an exponential
transformation on the effects of the exposures.}
}
\value{
An object of class \code{ggplot}.
}
\description{
This function draws a sort of manhattan plots using the p-value of the
association of the exposures with phenotypes of an \code{ExWAS} object.
}
\seealso{
\code{\link{exwas}} as a constructor for \code{\link{ExWAS}}
objects, \code{\link{extract}} to obtain a table with the result of
the ExWAS, \code{\link{plotEffect}} to see or compare effects of
one or two models.
}
