% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{plotPHE}
\alias{plotPHE}
\title{Plot association score between phentoypes and PCA}
\usage{
plotPHE(object, phenotype, exp2fac = 5)
}
\arguments{
\item{object}{An object oc class \link{ExposomePCA}}

\item{phenotype}{(optional) to select a set of phenotypes to be ploted.
If not given all are used.}

\item{exp2fac}{(default, \code{5}) Threshold to considere a phentoype
categorical (less or equal to) or continuous (more than).}
}
\value{
An object of class \code{ggplot}.
}
\description{
Function used to plot the association between the phentoypes in an
\link{ExposomePCA} and the values for each component of the PCA in the
same \link{ExposomePCA}
}
\examples{
data("exposome")
epca <- pca(expo[3:7, 1:100])
plotPHE(epca)
}
\seealso{
\link{pca} to compute PCA on an \link{ExposomeSet}, \link{plotEXP}
to plot the correlation between exposures ans PCA,
\link{ExposomePCA} as main class
}
