% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{plotLOD}
\alias{plotLOD}
\title{It draws a chart with the percentage of under-LOD values in an ExposomeSet}
\usage{
plotLOD(object, lod.col = "LOD", x.max = 100, sort = TRUE)
}
\arguments{
\item{object}{\link{ExposomeSet} which exposome will be plotted.}

\item{lod.col}{(default \code{"LOD"}) Name of the column in \code{fData}
containing the LOD thresholds.}

\item{x.max}{(default \code{100}) Fix the maxium value of the X-axis.}

\item{sort}{(default \code{TRUE}) If \code{TRUE} the chart will be ordered
from the features with less missing data to the ones with more under-LOD
values.}
}
\value{
A \code{ggplot} object.
}
\description{
This function can be used to draw the amount of under-LOD values in the
exposures of an \link{ExposomeSet}.
}
\examples{
data("exposome")
# The included has no missing data
plotLOD(expo)
}
\seealso{
\link{plotFamily} to draw the profile of a family of exposures,
\link{plotHistogram} to draw the shape of an exposure,
\link{tableMissings} to get a table with the missing data of an ExposomeSet,
\link{imputation} to impute missing data on the exposures of an ExposomeSet
}
