% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_AllClasses.R, R/02_plot.R,
%   R/imExposomeSet-dim.R, R/imExposomeSet-expos.R,
%   R/imExposomeSet-exposureNames.R, R/imExposomeSet-extract.R,
%   R/imExposomeSet-exwas.R, R/imExposomeSet-familyNames.R,
%   R/imExposomeSet-phenotypeNames.R, R/imExposomeSet-plotFamily.R,
%   R/imExposomeSet-sampleNames.R, R/imExposomeSet-subset.R,
%   R/imExposomeSet-toES.R
\docType{class}
\name{imExposomeSet}
\alias{imExposomeSet}
\alias{imExposomeSet-class}
\alias{plot,imExposomeSet,ANY-method}
\alias{dim,imExposomeSet-method}
\alias{expos,imExposomeSet-method}
\alias{exposureNames,imExposomeSet-method}
\alias{extract,imExposomeSet-method}
\alias{exwas,imExposomeSet-method}
\alias{familyNames,imExposomeSet-method}
\alias{phenotypeNames,imExposomeSet-method}
\alias{plotFamily,imExposomeSet-method}
\alias{sampleNames,imExposomeSet-method}
\alias{[[,imExposomeSet-method}
\alias{imExposomeSet-methods}
\alias{[,imExposomeSet,ANY,ANY,ANY-method}
\alias{[}
\alias{toES,imExposomeSet-method}
\title{Class imExposomeSet}
\usage{
\S4method{plot}{imExposomeSet,ANY}(x, y, ...)

\S4method{dim}{imExposomeSet}(x)

\S4method{expos}{imExposomeSet}(object)

\S4method{exposureNames}{imExposomeSet}(object)

\S4method{extract}{imExposomeSet}(object, rid = -1, ...)

\S4method{exwas}{imExposomeSet}(
  object,
  formula,
  filter,
  family,
  ...,
  baselevels,
  tef = TRUE,
  verbose = FALSE,
  warnings = TRUE,
  robust = FALSE
)

\S4method{familyNames}{imExposomeSet}(object, by.exposure = FALSE)

\S4method{phenotypeNames}{imExposomeSet}(object)

\S4method{plotFamily}{imExposomeSet}(x, family, group, group2, scatter = FALSE, na.omit = TRUE)

\S4method{sampleNames}{imExposomeSet}(object)

\S4method{[[}{imExposomeSet}(x, i)

\S4method{[}{imExposomeSet,ANY,ANY,ANY}(x, i, j, k, ..., drop = FALSE)

\S4method{toES}{imExposomeSet}(object, rid = 1)
}
\arguments{
\item{x}{An \code{\link{imExposomeSet}} object.}

\item{y}{NOT USED}

\item{...}{Other used arguments}

\item{object}{An object of class \code{\link{imExposomeSet}}}

\item{rid}{Number of the imputation to be extracted}

\item{formula}{Formula, not including exposures, to be tested.}

\item{filter}{Expression to be used to filter \code{\link{ExposomeSet}}}

\item{family}{Family descriving the nature of the health outcome}

\item{baselevels}{Labeled vector with the base-level of the
categorical exposures}

\item{tef}{If set to \code{TRUE} the threshold for effective
test is computed.}

\item{verbose}{If set to \code{TRUE} it shows messages on progression.}

\item{warnings}{If set to \code{TRUE} it shows warnings on progession.}

\item{by.exposure}{If set to \code{TRUE} ir returns the family which
each exposure belongs}

\item{group}{Phenotype to group exposures}

\item{group2}{NOT USED}

\item{scatter}{If set to true it shows the samples value in the plot}

\item{na.omit}{NOT USED}

\item{i}{Character coresponding to selected exposures.}

\item{j}{Character corresponding to selected sample names.}

\item{k}{Character corresponding to selected phenotypes.}

\item{drop}{NOT USED}
}
\value{
An object of class \code{imExposomeSet}
}
\description{
Class \code{imExposomeSet} was designed to store the exposures obtained
after a multiple imputation process done using \code{mice}. The
\code{data.frame} obtained from \code{mice} has the particulatiry
to contain the columns \code{.imp} and \code{.id} joint
to phenotypes and exposures. The slots \code{assayData}, \code{featureData},
and \code{phenoData} are coordinated.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot(x = imExposomeSet, y = ANY)}: Wrapper for \code{plotFamily} method.

\item \code{dim(imExposomeSet)}: Returns the number of exsures, samples and phenotypes.

\item \code{expos(imExposomeSet)}: Returns a \code{data.frame} with exposures.

\item \code{exposureNames(imExposomeSet)}: Method to obtain samples' names

\item \code{extract(imExposomeSet)}: Method to extract exposures for a single imputation

\item \code{exwas(imExposomeSet)}: Performs an EXposome-Wide Association Study

\item \code{familyNames(imExposomeSet)}: Getter to obtain the families's names of the
family of each exposure.

\item \code{phenotypeNames(imExposomeSet)}: Getter to obtain the families's names of the
family of each exposure.

\item \code{plotFamily(imExposomeSet)}: Draws a boxplot or accumulated-bar plot for each
exposure in the all imputed sets.

\item \code{sampleNames(imExposomeSet)}: Method to obtain samples' names

\item \code{[[}: Get an \code{ExposomeSet} with the selected
imputation

\item \code{x[i}: Subset an \code{imExposomeSet}

\item \code{toES(imExposomeSet)}: Returns an \code{\link{ExposomeSet}} with ethe given imputation.

}}
\section{Slots}{

\describe{
\item{\code{nimputation}}{Number of imputations done with \code{mice}.}

\item{\code{assayData}}{\code{data.frame} containing \code{.imp}, \code{.id} and
the exposures.}

\item{\code{featureData}}{\code{data.frame} containing the description of
the exposures.}

\item{\code{phenoData}}{\code{data.frame} containing \code{.imp}, \code{.id} and
the phenotypes.}
}}

\note{
Sample order is not guarantee
}
\seealso{
\code{\link{loadImputed}} to create an \code{imExposomeSet}
from \code{data.frames}
}
