% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{familyNames}
\alias{familyNames}
\title{Getter to obtain the exposures's names of an ExposomeSet.}
\usage{
familyNames(object, by.exposure = FALSE)
}
\arguments{
\item{object}{\code{ExposomeSet} that will be queried for the exposures's
family-names.}

\item{by.exposure}{(default \code{FALSE}) If \code{TRUE} a vector
labeled with each exposure name will be returned with the family of each
exposures. If \code{FALSE} a vector with the (unique) name of the families
of exposures will be returned.}
}
\value{
The families of the exposures into the \link{ExposomeSet}, or the
family of each exposure into the \link{ExposomeSet}.
}
\description{
This method returns the name of the families in an \link{ExposomeSet}, but
it can return a vector, labeled with the exposures in the
\link{ExposomeSet}, containing the family belonging to each exposure.
}
\examples{
data("exposome")
# Get families
familyNames(expo)
# Get the family of each exposure
familyNames(expo, by.exposure = TRUE)
}
\seealso{
\link{exposureNames} to get the name of the exposures,
\link{phenotypeNames} to get the phenotypes
}
