% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateWithMarkers.R
\name{annotateWithMarkers}
\alias{annotateWithMarkers}
\title{RETROFIT matching algorithm}
\usage{
annotateWithMarkers(marker_ref, K, decomp_w, decomp_h)
}
\arguments{
\item{marker_ref}{Key-value list: A dictionary of key: cell type, value: GeneExpression list}

\item{K}{integer: The number of cell types to be selected}

\item{decomp_w}{Matrix(GeneExpressions, Components): Decomposed w matrix}

\item{decomp_h}{Matrix(Components, Spots): Decomposed h matrix}
}
\value{
A list of
\itemize{
\item w
\item h
}
}
\description{
Match cell types based on correlations with reference. decomp_w   between matching algorithm description
}
\examples{
data("testSimulationData")
K            = 10
marker_ref   = testSimulationData$marker_ref
W            = testSimulationData$decompose$w
H            = testSimulationData$decompose$h

result       = retrofit::annotateWithMarkers(marker_ref=marker_ref, K=K, 
                                            decomp_w=W, decomp_h=H)
H_annotated  = result$h                                              
W_annotated  = result$w
ranked_cells = result$ranked_cells
}
\seealso{
papers reference
}
