% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterZeros.R
\name{filterZeros}
\alias{filterZeros}
\title{Filter zero-count exons.}
\usage{
filterZeros(rs_data)
}
\arguments{
\item{rs_data}{\code{\linkS4class{RegspliceData}} object.}
}
\value{
Returns a \code{\linkS4class{RegspliceData}} object.
}
\description{
Filter exons with zero RNA-seq read counts in all biological samples.
}
\details{
Removes exon bins with zero RNA-seq read counts in all biological samples. Any 
remaining single-exon genes (after filtering) are also removed (since differential
splicing requires multiple exon bins).

Input data is assumed to be in the form of a \code{RegspliceData} object. See 
\code{\link{RegspliceData}} for details.

After filtering zero-count exon bins, any remaining genes containing only a single
exon bin are also removed (since differential splicing requires multiple exon bins).

Filtering should be skipped when using exon microarray data. (When using the 
\code{regsplice} wrapper function, filtering can be disabled with the argument 
\code{filter = FALSE}).

Previous step: Create \code{RegspliceData} object with \code{\link{RegspliceData}}
constructor function.
Next step: Filter low-count exon bins with \code{\link{filterLowCounts}}.
}
\examples{
file_counts <- system.file("extdata/vignette_counts.txt", package = "regsplice")
data <- read.table(file_counts, header = TRUE, sep = "\t", stringsAsFactors = FALSE)
head(data)

counts <- data[, 2:7]
tbl_exons <- table(sapply(strsplit(data$exon, ":"), function(s) s[[1]]))
gene_IDs <- names(tbl_exons)
n_exons <- unname(tbl_exons)
condition <- rep(c("untreated", "treated"), each = 3)

rs_data <- RegspliceData(counts, gene_IDs, n_exons, condition)

rs_data <- filterZeros(rs_data)

}
\seealso{
\code{\linkS4class{RegspliceData}} \code{\link{filterLowCounts}}
}
