% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCrosswiseMatrix.R
\name{plotCrosswiseMatrix}
\alias{plotCrosswiseMatrix}
\title{plotCrosswiseMatrix}
\usage{
plotCrosswiseMatrix(mPT, lineColor = NA, interpolate = FALSE, colMatrix =
"default", matrix_type = "association", cor = "row",
maxVal = NA, main = "", ord_mat = NULL)
}
\arguments{
\item{mPT}{an object of class \link[=genoMatriXeR-class]{genoMatriXeR} or a numerical matrix.}

\item{lineColor}{logical, color for the line grid delineating the tiles of the matrix plot. If NA, no line will be drawn. (default = NA)}

\item{interpolate}{logical, if TRUE the image will be interpolated using the function \code{\link[=geom_raster]{geom_raster()}}. (default = FALSE)}

\item{colMatrix}{character or vector of colors, if "default" will be used a default selection see..}

\item{matrix_type}{character, type of matrix to be plotted, either "association" or "correlation". (default = "association")}

\item{cor}{character, if \code{matrix_type} is "correlation", choose if the function \code{\link[=cor]{cor()}} will be executed on each "row" or "col" of the matrix. (default = "row")}

\item{maxVal}{numeric, maximum absolute value displayed by the plot. If "max", the maximum values in the matrix are used. If NA, the 0.95 quantile of all absolute values is used. (default = NA)}

\item{main}{character, title of the plot. (default = "")}

\item{ord_mat}{numeric, list with two numeric vectors that represent the ordering of rows and column of the matrix to be used in the plot.
If NULL, the order of the matrix is preserved as is. (default = NULL)}
}
\value{
Returns a ggplot object.
}
\description{
Plot matrix of associations/correlations stored in a \link[=genoMatriXeR-class]{genoMatriXeR} object.
}
\details{
This functions creates a graphical representation of the matrix of associations
stored in a \link[=genoMatriXeR-class]{genoMatriXeR} object. The values plotted and
clustering options can be controlled when creating the matrix with the function
\link{makeCrosswiseMatrix}.
}
\examples{

data("cw_Alien")

cw_Alien_ReG <- makeCrosswiseMatrix( cw_Alien_ReG)

plotCrosswiseMatrix(cw_Alien_ReG, matrix_type = "association")

plotCrosswiseMatrix(cw_Alien_ReG, matrix_type = "correlation")


}
\seealso{
\link{crosswisePermTest} \link{makeCrosswiseMatrix}
}
