% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regioneReloaded_classes.R
\docType{class}
\name{genoMatriXeR-class}
\alias{genoMatriXeR-class}
\alias{gMXR}
\title{genoMatriXeR Class}
\description{
An S4 class for "genoMatriXeR" object.
}
\section{Slots}{

\describe{
\item{\code{parameters}}{List of parameters used to create the object.}

\item{\code{multiOverlaps}}{Results of multiple pairwise permutation tests generated with \code{\link[=crosswisePermTest]{crosswisePermTest()}}.}

\item{\code{matrix}}{List of numerical matrices containing z-score, pvalues and correlation values generated with \code{\link[=makeCrosswiseMatrix]{makeCrosswiseMatrix()}}}
}}

\examples{

data("cw_Alien")

AlienRSList_narrow_small  <- AlienRSList_narrow[c("regA","regB","regC")]

cw_test <- crosswisePermTest(Alist = AlienRSList_narrow_small,Blist = AlienRSList_narrow_small,
                            sampling = FALSE, genome = AlienGenome, per.chromosome = TRUE,
                            ranFUN = "resampleGenome", evFUN = "numOverlaps",
                            ntimes = 10, mc.cores = 2)

class(cw_test)

}
