% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampleRegions.R
\name{resampleRegions}
\alias{resampleRegions}
\title{Resample Regions}
\usage{
resampleRegions(A, universe, per.chromosome=FALSE, ...)
}
\arguments{
\item{A}{a region set in any of the formats accepted by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{universe}{a region set in any of the formats accepted by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{per.chromosome}{boolean indicating if sample must be by chromosome.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
a \code{\link{GenomicRanges}} object. A sample from the \code{univers} with the same length as A.
}
\description{
Function for sampling a region set from a universe of region sets.
}
\examples{
universe <- data.frame(chr=1, start=c(1,15,24,40,50), end=c(10,20,30,45,55))

A <- data.frame(chr=1, start=c(2,12,28,35), end=c(5,25,33,43))

resampleRegions(A, universe, per.chromosome=TRUE)
 
}
\seealso{
\code{\link{toDataframe}}, \code{\link{toGRanges}}, \code{\link{randomizeRegions}}, \code{\link{createRandomRegions}}
}
