% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_metadata.R
\name{all_metadata}
\alias{all_metadata}
\title{This function downloads the metadata for all projects.}
\usage{
all_metadata(subset = "sra", verbose = TRUE)
}
\arguments{
\item{subset}{Either \code{sra},  \code{gtex} or \code{tcga}. Specifies
which metadata file to download.}

\item{verbose}{If \code{TRUE} it will print a message of where the file is
being downloaded to.}
}
\value{
A \link[S4Vectors:DataFrame-class]{DataFrame-class} object with the phenotype
metadata.
}
\description{
Download the metadata from all the projects. This can be useful for finding
samples of interests across all projects.
}
\details{
Note that for \code{subset = 'gtex'}, there are more variables than
the ones we have for 'sra'. This information corresponds to file
GTEx_Data_V6_Annotations_SampleAttributesDS.txt available at
\url{http://www.gtexportal.org/home/datasets}. There you can find the
information describing these variables.

For TCGA we acquired metadata information from 3 different sources:
\itemize{
\item GDC: via a json query
\item CGC: via json queries and a custom script to merge the tables
\item TCGAbiolinks: we used to to parse GDC's XML files
For more information, check \url{https://github.com/leekgroup/recount-website/tree/master/metadata/tcga_prep}.
}
}
\examples{

metadata <- all_metadata()
}
\author{
Leonardo Collado-Torres
}
