% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abstract_search.R
\name{abstract_search}
\alias{abstract_search}
\title{Search the abstracts from the SRA studies available via the recount project}
\usage{
abstract_search(query, id_only = FALSE, ...)
}
\arguments{
\item{query}{A character vector with the text to search for via
\link[base:grep]{grep} in the abstract info available at \link{recount_abstract}.}

\item{id_only}{Whether to only return the project id or to return summary
information for the project(s) that match the query.}

\item{...}{Additional arguments passed to \link[base:grep]{grep}.}
}
\value{
If \code{id_only = TRUE} it returns a character vector with the
project SRA ids (accession numbers). If \code{id_only = FALSE} it returns a
subset of \link{recount_abstract} for the abstracts that contained the query.
}
\description{
Given a text query, find the SRA project ids (study accession numbers) that
contain the text in their abstract as provided by the SRAdb Bioconductor
package.
}
\details{
Both the query and the abstracts are searched in lower case.

For a more powerful search use the recount project website at
\url{https://jhubiostatistics.shinyapps.io/recount/}.
}
\examples{
## Find the Geuvadis consortium project
project_info <- abstract_search("Geuvadis consortium")

## See some summary information for this project
project_info
}
\seealso{
\link{browse_study}, \link{recount_abstract}
}
\author{
Leonardo Collado-Torres
}
