% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_getTestStats.R
\name{getTestStats}
\alias{getTestStats}
\title{A function to calculate observed and permuation z-statistics
on a n-by-p matrix of observations}
\usage{
getTestStats(
  Y,
  center,
  test = "wilcox.test",
  x,
  B,
  argList,
  tieBreakRan,
  replace,
  scale
)
}
\arguments{
\item{Y}{The nxp data matrix}

\item{center}{a boolean, should data be centered prior to permuation}

\item{test}{A function name, possibly user defined. See details.}

\item{x}{A vector defining the groups. Will be coerced to factor.}

\item{B}{an integer, the number of permuations}

\item{argList}{A list of further arguments passed on to the test function}

\item{tieBreakRan}{A boolean, should ties of permutation test statistics
be broken randomly? If not, midranks are used}

\item{replace}{A boolean. If FALSE, samples are permuted
(resampled without replacement), if TRUE the samples are bootstrapped
(resampled with replacement)}

\item{scale}{a boolean, should data be scaled prior to resampling}
}
\value{
A list with components
\item{statObs}{A vector of length p of observed test statistics}
\item{statsPerm}{A p-by-B matrix of permutation test statistics}
\item{resamDesign}{The resampling design}
}
\description{
A function to calculate observed and permuation z-statistics
on a n-by-p matrix of observations
}
\details{
For test "wilcox.test" and "t.test",
fast custom implementations are used. Other functions can be supplied
but must accept a y outcome variable, a x as grouping variable, and possibly
a list of other arguments. It must return all arguments needed to evaluate
its quantile function if z-values are to be used.
}
