% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDrugActivityRepeats.R
\name{plotDrugActivityRepeats}
\alias{plotDrugActivityRepeats}
\title{Plot NCI-60 drug activity profiles for repeat experiments.}
\usage{
plotDrugActivityRepeats(
  nscStr,
  useZScore = FALSE,
  maxRepNum = 5,
  pdfFilename = NULL,
  pdfWidth = 12,
  pdfHeight = 6
)
}
\arguments{
\item{nscStr}{a string specifying the NSC identifier for a compound.}

\item{useZScore}{a boolean specifying whether to plot z-transformed data 
(as opposed to -logGI50 values).}

\item{maxRepNum}{an integer specifying the maximum number of repeat experiments to plot.}

\item{pdfFilename}{name of a PDF output}

\item{pdfWidth}{with of the PDF (default: 12)}

\item{pdfHeight}{with of the PDF (default: 6)}
}
\value{
NONE
}
\description{
Plot NCI-60 drug activity profiles for repeat experiments.
}
\examples{
plotDrugActivityRepeats("609699")
plotDrugActivityRepeats("609699", useZScore=TRUE, maxRepNum=3)

}
\concept{rcellminer}
