% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBinaryMutationData.R
\name{getBinaryMutationData}
\alias{getBinaryMutationData}
\title{Compute a binary gene mutation data matrix from SNP and other mutation
event-level data.}
\usage{
getBinaryMutationData(
  mutInfo,
  mutData,
  maxVariantFreq = 0.2,
  maxNormalPopulationFreq = 0.005,
  maxSiftScore = 0.05,
  minPolyPhenScore = 0.85
)
}
\arguments{
\item{mutInfo}{A data frame with the following named columns:
Gene, the name of the gene associated with the mutation event;
probe.ids, a unique identifier specifying the mutation event;
SNP_1000_genome, the frequency of the mutation event in SNP 1000;
ESP5400, the frequency of the mutation event in ESP5400;
SNP_type, the type of mutation event, chosen from "MISSENSE", "FRAMESHIFT", 
"NONFRAMESHIFT", "NONSENSE", "SPLICING";
SIFT_score, the SIFT score;
Polyphen_score, the POLYPHEN score.
Rownames of mutInfo should be set to probe.ids, i.e., the unique mutation
event specifier.}

\item{mutData}{A matrix with event level mutation information, with SNPs, etc.
along rows and samples along columns.  Rownames of mutData should exactly
match those of mutInfo.  The i-th row of mutInfo should thus give detailed
information for the mutation event with data specified in the i-th row of
mutData.}

\item{maxVariantFreq}{The maximum proportion of mutant samples (used to
exclude frequently occuring events); default value = 0.2.}

\item{maxNormalPopulationFreq}{The maximum freqency of a mutation in the normal
population (used to exclude likely germline variants); default value = 0.005.}

\item{maxSiftScore}{The maximum accepted SIFT score (used to exclude 
presumed non-deleterious mutations); default value = 0.05.}

\item{minPolyPhenScore}{The minimum accepted POLYPHEN score (used to
exclude presumed non-deleterious mutations); default value = 0.85.}
}
\value{
A binary gene mutation matrix, with genes along rows, samples
along columns, and 1s indicating deleterious mutations.
}
\description{
Compute a binary gene mutation data matrix from SNP and other mutation
event-level data.
}
\concept{rcellminer}
