% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDocumentation.R
\docType{data}
\name{elNetMolDataNCI60}
\alias{elNetMolDataNCI60}
\title{NCI60 Molecular Data}
\description{
Z-scores of values for a variety of assays conducted on the NCI-60 to facilitate comparison.
Z-scores calculated over the 60 cell lines for the given feature.
}
\details{
A list containing various assay values:  
\itemize{
 \item{cop} { Copy number values; Described in Pubmed ID: 24670534 }
 \item{exp} { Expression values; Obtained from "RNA: 5 Platform Gene Transcript" 
   \url{http://discover.nci.nih.gov/cellminer/loadDownload.do}; Missing values 
   imputed using the R package "impute" }
 \item{mut} { Mutation values; Deleterious mutations obtained from TODO }
 \item{mir} { MicroRNA values; Obtained from "RNA: Agilent Human microRNA (V2)"
   \url{http://discover.nci.nih.gov/cellminer/loadDownload.do} }
 \item{pro} { Reverse protein lysate array values; Obtain from "Protein: Lysate Array"
   \url{http://discover.nci.nih.gov/cellminer/loadDownload.do} }
 \item{mda} { NCI-60 metadata. 
   \itemize{ 
     \item{CNV_GAIN} {Proportion of genome copy number gains; Described in Pubmed ID: 24670534} 
     \item{CNV_LOSS} {Proportion of genome copy number losses; Described in Pubmed ID: 24670534} 
     \item{CNV_TOTAL} {Sum of CNV_GAIN and CNV_LOSS} 
     \item{P53_BIN} {Binary TP53 profile curated by William Reinhold } 
     \item{MSI_OGAN_BIN} {Binary microsatellite instability (MSI) profile curated by Ogan Abaan using COSMIC data; Obtained from Supplementary Table 1 - Ogan Whole Exome Sequencing (WES) paper in Cancer Res. } 
     \item{EPITHELIAL} {Epithelial by tissue of origin - pattern extracted from the CellMiner cell line metadata \url{http://discover.nci.nih.gov/cellminer/celllineMetadata.do} } 
     \item{EPITHELIAL_KURT} {Kurt Kohn curation for epithelial-like cell lines based on molecular parameters described in Pubmed ID: 24940735} 
     \item{DELETERIOUS} {Total deleterious variants from WES dataset; Fabricio Sousa curation} 
     \item{MISSENSE} {Total missense variants from WES dataset; Fabricio Sousa curation} 
     \item{SILENT} {Total silent variants from WES dataset; Fabricio Sousa curation} 
     \item{TOTAL_AA} {Total amino acid changing variants from WES dataset; Fabricio Sousa curation} 
     \item{CELL-CELL} {Cell-to-cell adhesion curated by William Reinhold } 
     \item{DOUBLINGTIME} {The doubling time pattern was extracted from the CellMiner cell line metadata 
       \url{http://discover.nci.nih.gov/cellminer/celllineMetadata.do} } 
   }
 }
}
}
\references{
\url{http://discover.nci.nih.gov/cellminer}
}
\author{
Vinodh Rajapakse \email{vinodh.rajapakse AT nih.gov}
}
\concept{rcellminer}
\keyword{data}
