% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawDiag.R
\name{plotPrecursorHeatmap}
\alias{plotPrecursorHeatmap}
\alias{PlotPrecursorHeatmap}
\title{Precursor Mass versus StartTime MS2 based hexagons}
\usage{
plotPrecursorHeatmap(x, method = "overlay", bins = 80)
}
\arguments{
\item{x}{a \code{data.frame} object adhering to the specified criteria for
the \code{is.rawDiag} function.}

\item{method}{specifying the plot method 'trellis' | 'violin' | 'overlay'.
The default is 'trellis'.}

\item{bins}{number of bins in both vertical and horizontal directions. default is 80.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Precursor Mass versus StartTime MS2 based hexagons
}
\note{
TODO: define bin with dynamically as h= 2x IQR x n e-1/3 or number of bins (max-min)/h
}
\examples{
rawrr::sampleFilePath() |> rawDiag::readRaw() |> rawDiag::plotPrecursorHeatmap()
}
\references{
\itemize{
\item rawDiag: \doi{10.1021/acs.jproteome.8b00173},
\item rawrr: \doi{10.1021/acs.jproteome.0c00866}
}
}
\author{
Christian Trachsel (2017)
}
