% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_Methods.R
\name{PCCI}
\alias{PCCI}
\title{PhyloTaxonomic Consistency Cophenetic Index}
\usage{
PCCI(tr, mt = NULL)
}
\arguments{
\item{tr}{Phylogenetic tree. If the tree contains sample names in the labels, provide
metadata. If it already contains the names of the taxa, just provide the tree.}

\item{mt}{Metadata. The metadata should have the following format: 
the first column should contain the names of the samples, 
exactly as they appear on the tree label; 
the second column should contain the corresponding taxa.
If the tree already has the labels renamed according to the taxon, 
it is not necessary to provide metadata.}
}
\value{
The PCCI index for each taxon and the mean value

        `PCCI' returns a `list` containing:
\itemize{
         \item tab: the PCCI value for each taxon in a two-colunm output: taxa and cost
         \item mean: the mean value of PCCI metric
        }
}
\description{
Phylogenetic tree evaluation function, estimate of how grouped 
             the samples of the same taxon are in the phylogenetic tree.
}
\details{
Empty or NA labels are removed from analyses
}
\examples{

# Load the sample tree and its metadata
pathtree <- system.file(package = "rSWeeP" , "examples" , "tree_Mitochondrial.tree")
tree = ape::read.tree(pathtree)
pathmetadata <- system.file(package = "rSWeeP" , "examples" , "metadata_mitochondrial.csv")
mt = read.csv(pathmetadata,header=TRUE)

data = data.frame(sp=mt$fileName,family=mt$family) 
PCCI(tree,data)

}
\author{
Camila P. Perico
}
