/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.rrnaclassifier;

import edu.msu.cme.rdp.classifier.ClassificationResult;
import edu.msu.cme.rdp.classifier.HierarchyTree;
import edu.msu.cme.rdp.classifier.RankAssignment;
import edu.msu.cme.rdp.classifier.utils.ClassifierFactory;
import edu.msu.cme.rdp.classifier.utils.ClassifierSequence;
import edu.msu.cme.rdp.classifier.utils.HierarchyVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;

public class ClassificationParser {
    private BufferedReader reader;
    private static HierarchyTree root;
    private static HierarchyVersion versionNo;

    public ClassificationParser(String fileName, ClassifierFactory classifierFactory) throws FileNotFoundException {
        this(new FileInputStream(fileName), classifierFactory);
    }

    public ClassificationParser(File f, ClassifierFactory classifierFactory) throws FileNotFoundException {
        this(new FileInputStream(f), classifierFactory);
    }

    public ClassificationParser(InputStream is, ClassifierFactory classifierFactory) {
        root = classifierFactory.getRoot();
        versionNo = classifierFactory.getHierarchyTrainsetNo();
        this.reader = new BufferedReader(new InputStreamReader(is));
    }

    public ClassificationParser(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public HierarchyTree getRoot() {
        return root;
    }

    public ClassificationResult next() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        String delimiter = "\t";
        if (line.contains(";")) {
            delimiter = ";";
        }
        String[] tokens = line.split(delimiter);
        ArrayList<RankAssignment> assignments = new ArrayList<RankAssignment>();
        ClassifierSequence seq = new ClassifierSequence(tokens[0], "", "");
        boolean seqreversed = tokens[1].equalsIgnoreCase("-");
        if (!root.getName().equalsIgnoreCase(tokens[2].trim()) || !root.getRank().equalsIgnoreCase(tokens[3].trim())) {
            throw new IllegalArgumentException("Root of \"" + line + "\" does not match the Root node in the original Classifier training data: " + root.getName() + "\t" + root.getRank());
        }
        HierarchyTree currRoot = root;
        assignments.add(new RankAssignment(currRoot, Float.valueOf(tokens[4].trim()).floatValue()));
        for (int index = 5; index < tokens.length; index += 3) {
            String nextName = tokens[index].trim();
            boolean found = false;
            for (HierarchyTree tree : currRoot.getSubclasses()) {
                if (!tree.getName().equals(nextName)) continue;
                currRoot = tree;
                assignments.add(new RankAssignment(currRoot, Float.valueOf(tokens[index + 2].trim()).floatValue()));
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("taxon Node " + nextName + " in line \"" + line + "\" is not found in the original Classifier training data.");
        }
        return new ClassificationResult(seq, seqreversed, assignments, versionNo);
    }
}

