/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.comparison;

import edu.msu.cme.rdp.classifier.ClassificationResult;
import edu.msu.cme.rdp.classifier.Classifier;
import edu.msu.cme.rdp.classifier.RankAssignment;
import edu.msu.cme.rdp.classifier.ShortSequenceException;
import edu.msu.cme.rdp.classifier.TrainingDataException;
import edu.msu.cme.rdp.classifier.cli.CmdOptions;
import edu.msu.cme.rdp.classifier.comparison.AbstractNode;
import edu.msu.cme.rdp.classifier.comparison.ComparisonResultTreeSet;
import edu.msu.cme.rdp.classifier.comparison.Score;
import edu.msu.cme.rdp.classifier.comparison.SeqInfo;
import edu.msu.cme.rdp.classifier.comparison.SigCalculator;
import edu.msu.cme.rdp.classifier.comparison.TaxonTree;
import edu.msu.cme.rdp.classifier.io.ClassificationResultFormatter;
import edu.msu.cme.rdp.classifier.utils.ClassifierFactory;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class ComparisonCmd {
    public static final String QUERYFILE1_LONG_OPT = "queryFile1";
    public static final String QUERYFILE2_LONG_OPT = "queryFile2";
    public static final String COMPARE_OUTFILE_LONG_OPT = "compare_outputFile";
    public static final String QUERYFILE1_SHORT_OPT = "q1";
    public static final String QUERYFILE2_SHORT_OPT = "q2";
    public static final String COMPARE_OUTFILE_SHORT_OPT = "o";
    public static final String QUERYFILE_DESC = "query file contains sequences in one of the following formats: Fasta, Genbank and EMBL.";
    public static final String COMPARE_OUTFILE_DESC = "output file name for the comparsion results.";
    private static Options options = new Options();
    private ClassifierFactory factory;
    private float confidenceCutoff = CmdOptions.DEFAULT_CONF;
    private static final String SAMPLE1 = "sample1";
    private static final String SAMPLE2 = "sample2";

    public ComparisonCmd(String propfile, String gene) throws IOException, TrainingDataException {
        if (propfile != null) {
            ClassifierFactory.setDataProp(propfile, false);
        }
        this.factory = ClassifierFactory.getFactory(gene);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClassify(String s1, String s2, String detailFile, String sigFile, ClassificationResultFormatter.FORMAT format) throws IOException {
        FileInputStream inStream1 = new FileInputStream(s1);
        FileInputStream inStream2 = new FileInputStream(s2);
        BufferedWriter wt = new BufferedWriter(new FileWriter(detailFile));
        Classifier aClassifier = this.factory.createClassifier();
        TaxonTree root = null;
        SequenceReader parser = null;
        Sequence pSeq = null;
        boolean count = false;
        try {
            ClassificationResult result;
            parser = new SequenceReader((InputStream)inStream1);
            while ((pSeq = parser.readNextSequence()) != null) {
                try {
                    result = aClassifier.classify(pSeq);
                    root = this.reconstructTree(result, root, SAMPLE1);
                    wt.write(ClassificationResultFormatter.getOutput(result, format));
                }
                catch (ShortSequenceException e) {
                    System.out.println(e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            parser = new SequenceReader((InputStream)inStream2);
            while ((pSeq = parser.readNextSequence()) != null) {
                try {
                    result = aClassifier.classify(pSeq);
                    root = this.reconstructTree(result, root, SAMPLE2);
                    wt.write(ClassificationResultFormatter.getOutput(result, format));
                }
                catch (ShortSequenceException e) {
                    System.out.println(e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            parser.close();
            wt.close();
        }
        if (root != null) {
            SigCalculator cal = new SigCalculator(root.getS1Count(), root.getS2Count(), this.confidenceCutoff);
            root.changeConfidence(cal);
            BufferedWriter sigWt = new BufferedWriter(new FileWriter(sigFile));
            sigWt.write("sample1:\t" + s1 + "\n");
            sigWt.write("sample2:\t" + s2 + "\n");
            sigWt.write("confidence:\t" + this.confidenceCutoff + "\n");
            this.printSignificance(root, sigWt);
            sigWt.close();
        }
    }

    private TaxonTree reconstructTree(ClassificationResult result, TaxonTree root, String sample) {
        List<RankAssignment> assignments = result.getAssignments();
        Iterator<RankAssignment> assignIt = assignments.iterator();
        int nodeCount = 0;
        SeqInfo seqInfo = new SeqInfo(result.getSequence().getSeqName(), result.getSequence().getDesc());
        seqInfo.setReverse(result.isReverse());
        TaxonTree curTree = null;
        while (assignIt.hasNext()) {
            RankAssignment assign = assignIt.next();
            if (nodeCount == 0) {
                if (root == null) {
                    root = new TaxonTree(assign.getTaxid(), assign.getName(), assign.getRank(), null);
                } else if (root.getTaxid() != assign.getTaxid()) {
                    throw new IllegalStateException("Error: the root " + assign.getTaxid() + " of assignment for " + result.getSequence().getSeqName() + " is different from the other sequences " + root.getTaxid());
                }
                curTree = root;
            } else {
                curTree = curTree.getChildbyTaxid(assign.getTaxid(), assign.getName(), assign.getRank());
            }
            Score score = new Score(assign.getConfidence(), seqInfo, curTree);
            if (sample.equals(SAMPLE1)) {
                curTree.addS1Score(score);
            } else {
                curTree.addS2Score(score);
            }
            ++nodeCount;
        }
        return root;
    }

    private void printSignificance(TaxonTree root, BufferedWriter wt) throws IOException {
        ComparisonResultTreeSet resultSet = new ComparisonResultTreeSet();
        Iterator taxonIt = root.getTaxonIterator(10);
        while (taxonIt.hasNext()) {
            resultSet.add(taxonIt.next());
        }
        Iterator it = resultSet.iterator();
        wt.write("Significance\tRank\tName\tSample1\tSample2\n");
        while (it.hasNext()) {
            AbstractNode node = (AbstractNode)it.next();
            wt.write(node.getSignificance() + "\t" + node.getRank() + "\t" + node.getName() + "\t" + node.getS1Count() + "\t" + node.getS2Count() + "\n");
        }
    }

    private void setConfidenceCutoff(float conf) {
        if (conf < 0.0f || conf > 1.0f) {
            throw new IllegalArgumentException("The confidence cutoff value should be between 0 - 1.0");
        }
        this.confidenceCutoff = conf;
    }

    public static void printLicense() {
        String license = "Copyright 2006-2011 Michigan State University Board of Trustees.\n\nThis program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA\n\nAuthors's mailng address:\nCenter for Microbial Ecology\n2225A Biomedical Physical Science\nMichigan State University\nEast Lansing, Michigan USA 48824-4320\nE-mail: James R. Cole at colej@msu.edu\n\tQiong Wang at wangqion@msu.edu\n\tJames M. Tiedje at tiedjej@msu.edu\n\n";
        System.err.println(license);
    }

    public static void main(String[] args) throws Exception {
        String queryFile1 = null;
        String queryFile2 = null;
        String class_outputFile = null;
        String compare_outputFile = null;
        String propFile = null;
        ClassificationResultFormatter.FORMAT format = CmdOptions.DEFAULT_FORMAT;
        float conf_cutoff = CmdOptions.DEFAULT_CONF;
        String gene = null;
        try {
            CommandLine line = new PosixParser().parse(options, args);
            if (!line.hasOption(QUERYFILE1_SHORT_OPT)) {
                throw new Exception("queryFile1 must be specified");
            }
            queryFile1 = line.getOptionValue(QUERYFILE1_SHORT_OPT);
            if (!line.hasOption(QUERYFILE2_SHORT_OPT)) {
                throw new Exception("queryFile2 must be specified");
            }
            queryFile2 = line.getOptionValue(QUERYFILE2_SHORT_OPT);
            if (!line.hasOption(COMPARE_OUTFILE_SHORT_OPT)) {
                throw new Exception("outputFile for classification results must be specified");
            }
            class_outputFile = line.getOptionValue(COMPARE_OUTFILE_SHORT_OPT);
            if (!line.hasOption(COMPARE_OUTFILE_SHORT_OPT)) {
                throw new Exception("outputFile for comparsion results must be specified");
            }
            compare_outputFile = line.getOptionValue(COMPARE_OUTFILE_SHORT_OPT);
            if (line.hasOption("t")) {
                if (gene != null) {
                    throw new IllegalArgumentException("Already specified the gene from the default location. Can not specify train_propfile");
                }
                propFile = line.getOptionValue("t");
            }
            if (line.hasOption("c")) {
                conf_cutoff = Float.parseFloat(line.getOptionValue("c"));
            }
            if (line.hasOption("f")) {
                String f = line.getOptionValue("f");
                if (f.equalsIgnoreCase("allrank")) {
                    format = ClassificationResultFormatter.FORMAT.allRank;
                } else if (f.equalsIgnoreCase("fixrank")) {
                    format = ClassificationResultFormatter.FORMAT.fixRank;
                } else if (f.equalsIgnoreCase("filterbyconf")) {
                    format = ClassificationResultFormatter.FORMAT.filterbyconf;
                } else if (f.equalsIgnoreCase("db")) {
                    format = ClassificationResultFormatter.FORMAT.dbformat;
                } else {
                    throw new IllegalArgumentException("Not valid output format, only allrank, fixrank, filterbyconf and db allowed");
                }
            }
            if (line.hasOption("g")) {
                if (propFile != null) {
                    throw new IllegalArgumentException("Already specified train_propfile. Can not specify gene any more");
                }
                gene = line.getOptionValue("g").toLowerCase();
                if (!gene.equals("16srrna") && !gene.equals("fungallsu")) {
                    throw new IllegalArgumentException(gene + " is NOT valid, only allows " + "16srrna" + " and " + "fungallsu");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Command Error: " + e.getMessage());
            new HelpFormatter().printHelp(120, "ComparisonCmd", "", options, "", true);
            return;
        }
        if (propFile == null && gene == null) {
            gene = "16srrna";
        }
        ComparisonCmd cmd = new ComparisonCmd(propFile, gene);
        cmd.setConfidenceCutoff(conf_cutoff);
        ComparisonCmd.printLicense();
        cmd.doClassify(queryFile1, queryFile2, class_outputFile, compare_outputFile, format);
    }

    static {
        options.addOption(new Option(QUERYFILE1_SHORT_OPT, QUERYFILE1_LONG_OPT, true, QUERYFILE_DESC));
        options.addOption(new Option(QUERYFILE2_SHORT_OPT, QUERYFILE2_LONG_OPT, true, QUERYFILE_DESC));
        options.addOption(new Option(COMPARE_OUTFILE_SHORT_OPT, "outputFile", true, "tab-delimited text output file for classification assignment."));
        options.addOption(new Option(COMPARE_OUTFILE_SHORT_OPT, COMPARE_OUTFILE_LONG_OPT, true, COMPARE_OUTFILE_DESC));
        options.addOption(new Option("t", "train_propfile", true, "property file containing the mapping of the training files if not using the default. Note: the training files and the property file should be in the same directory."));
        options.addOption(new Option("f", "format", true, CmdOptions.FORMAT_DESC));
        options.addOption(new Option("c", "conf", true, CmdOptions.BOOTSTRAP_DESC));
        options.addOption(new Option("g", "gene", true, CmdOptions.GENE_DESC));
    }
}

