/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.comparison;

import edu.msu.cme.rdp.classifier.comparison.ComparisonBrowserNode;
import edu.msu.cme.rdp.classifier.comparison.SigCalculator;
import edu.msu.cme.rdp.classifier.comparison.Taxon;
import edu.msu.cme.rdp.classifier.comparison.UncNode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractNode
implements Taxon,
ComparisonBrowserNode {
    private static DecimalFormat df = new DecimalFormat("0.##E0");
    private int indent;
    private AbstractNode parent;
    private AbstractNode nextSibling;
    private int s1Count = 0;
    private int s2Count = 0;
    private double significance = 0.0;

    @Override
    public Iterator getTaxonIterator(int depth) {
        TaxonIterator it = new TaxonIterator(depth);
        return it;
    }

    @Override
    public Iterator getLineageIterator() {
        LineageIterator it = new LineageIterator();
        return it;
    }

    @Override
    public abstract Iterator getDetailIterator(float var1);

    @Override
    public abstract void changeConfidence(SigCalculator var1);

    abstract AbstractNode getFirstChild();

    @Override
    public abstract ComparisonBrowserNode findNode(int var1);

    @Override
    public abstract String getName();

    @Override
    public abstract String getRank();

    @Override
    public abstract int getTaxid();

    AbstractNode getParent() {
        return this.parent;
    }

    AbstractNode getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public int getS1Count() {
        return this.s1Count;
    }

    @Override
    public int getS2Count() {
        return this.s2Count;
    }

    public double getDoubleSignificance() {
        return this.significance;
    }

    @Override
    public String getSignificance() {
        if (this instanceof UncNode) {
            return "NA";
        }
        return df.format(this.significance).toString();
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    void incS1Count(int c) {
        this.s1Count += c;
    }

    void incS2Count(int c) {
        this.s2Count += c;
    }

    void resetCount() {
        this.s1Count = 0;
        this.s2Count = 0;
    }

    void setParent(AbstractNode n) {
        this.parent = n;
    }

    void setIndent(int d) {
        this.indent = d;
    }

    void setSignificance(double s) {
        this.significance = s;
    }

    void addSibling(AbstractNode n) {
        if (this.nextSibling == null) {
            this.nextSibling = n;
            return;
        }
        this.nextSibling.addSibling(n);
    }

    class LineageIterator
    implements Iterator {
        private ArrayList lineage = new ArrayList();
        private Object onDeck;
        private int index;

        public LineageIterator() {
            AbstractNode node = AbstractNode.this.parent;
            while (node != null) {
                this.lineage.add(node);
                node = node.parent;
            }
            if (!this.lineage.isEmpty()) {
                this.index = this.lineage.size() - 1;
                this.onDeck = this.lineage.get(this.index--);
            }
        }

        @Override
        public boolean hasNext() {
            return this.onDeck != null;
        }

        public Object next() {
            Object tmp;
            if (this.onDeck != null) {
                tmp = this.onDeck;
                if (this.index >= 0) {
                    this.onDeck = this.lineage.get(this.index);
                    --this.index;
                } else {
                    this.onDeck = null;
                }
            } else {
                throw new NoSuchElementException();
            }
            return tmp;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
        }
    }

    class TaxonIterator
    implements Iterator {
        private int depth;
        private AbstractNode root;
        private AbstractNode onDeck;
        private final int ROOT_INDENT = 0;

        public TaxonIterator(int depth) {
            this.depth = depth;
            this.root = AbstractNode.this;
            this.root.setIndent(0);
            this.onDeck = this.root;
        }

        public Object next() {
            AbstractNode tmp;
            if (this.onDeck != null) {
                tmp = this.onDeck;
                this.onDeck = this.getNextElement();
                while (this.onDeck != null && this.onDeck.s1Count <= 0 && this.onDeck.s2Count <= 0) {
                    this.onDeck = this.getNextElement();
                }
            } else {
                throw new NoSuchElementException();
            }
            return tmp;
        }

        @Override
        public boolean hasNext() {
            return this.onDeck != null;
        }

        private AbstractNode getNextElement() {
            AbstractNode nextNode = null;
            if (this.onDeck.indent < this.depth - 1 && this.onDeck.getFirstChild() != null) {
                nextNode = this.onDeck.getFirstChild();
            } else if (this.onDeck.getTaxid() != this.root.getTaxid() && (nextNode = this.onDeck.nextSibling) == null) {
                AbstractNode parent = this.onDeck.parent;
                while (parent != null && parent.getTaxid() != this.root.getTaxid() && (nextNode = parent.nextSibling) == null) {
                    parent = parent.parent;
                }
            }
            if (nextNode != null) {
                nextNode.setIndent(nextNode.parent.indent + 1);
            }
            return nextNode;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
        }
    }
}

