/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.pairwise;

import edu.msu.cme.rdp.alignment.AlignmentMode;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseAlignment;
import edu.msu.cme.rdp.alignment.pairwise.ScoringMatrix;
import java.util.ArrayList;
import java.util.Collections;

public class PairwiseAligner {
    private static final int match = 0;
    private static final int gap = 1;
    private static final int left = 0;
    private static final int up = 1;
    private static final int diag = 2;
    private static final int trace = 2;

    public static void reverse(StringBuffer s) {
        int l = s.length() - 1;
        for (int index = 0; index < (l + 1) / 2; ++index) {
            char c = s.charAt(index);
            s.setCharAt(index, s.charAt(l - index));
            s.setCharAt(l - index, c);
        }
    }

    private static int[][][] populateMatrix(char[] seqi, char[] seqj, ScoringMatrix matrix, AlignmentMode mode) {
        int initScore;
        int index;
        int[][][] scoringMatrix = new int[seqi.length + 1][seqj.length + 1][3];
        scoringMatrix[0][0][0] = 0;
        scoringMatrix[0][0][1] = Integer.MIN_VALUE;
        for (index = 1; index < seqi.length + 1; ++index) {
            scoringMatrix[index][0][0] = initScore = mode == AlignmentMode.global ? (index - 1) * matrix.getGapExtend() + matrix.getGapOpen() : 0;
            scoringMatrix[index][0][1] = initScore + matrix.getGapExtend();
            scoringMatrix[index][0][2] = 0;
        }
        for (index = 1; index < seqj.length + 1; ++index) {
            scoringMatrix[0][index][0] = initScore = mode == AlignmentMode.global || mode == AlignmentMode.glocal ? (index - 1) * matrix.getGapExtend() + matrix.getGapOpen() : 0;
            scoringMatrix[0][index][1] = initScore + matrix.getGapExtend();
            scoringMatrix[0][index][2] = 1;
        }
        for (int i = 1; i < seqi.length + 1; ++i) {
            for (int j = 1; j < seqj.length + 1; ++j) {
                int sxy = matrix.score(Character.valueOf(seqi[i - 1]), Character.valueOf(seqj[j - 1]));
                int scoreUp = Math.max(scoringMatrix[i - 1][j][1] + matrix.getGapExtend(), scoringMatrix[i - 1][j][0] + matrix.getGapOpen());
                int scoreLeft = Math.max(scoringMatrix[i][j - 1][1] + matrix.getGapExtend(), scoringMatrix[i][j - 1][0] + matrix.getGapOpen());
                int m = Math.max(scoringMatrix[i - 1][j - 1][0], scoringMatrix[i - 1][j - 1][1]) + sxy;
                if (mode == AlignmentMode.local) {
                    scoringMatrix[i][j][0] = m < 0 ? 0 : m;
                    scoringMatrix[i][j][1] = Math.min(0, Math.max(scoreLeft, scoreUp));
                } else {
                    scoringMatrix[i][j][0] = m;
                    scoringMatrix[i][j][1] = Math.max(scoreLeft, scoreUp);
                }
                scoringMatrix[i][j][2] = m >= scoreLeft && m >= scoreUp ? 2 : (scoreLeft >= m && scoreLeft >= scoreUp ? 1 : 0);
            }
        }
        return scoringMatrix;
    }

    private static PairwiseAlignment traceback(int[][][] scoringMatrix, char[] seqi, char[] seqj, AlignmentMode mode) {
        StringBuffer alignedSeqi = new StringBuffer();
        StringBuffer alignedSeqj = new StringBuffer();
        ArrayList<Integer> scores = new ArrayList<Integer>();
        int i = seqi.length;
        int j = seqj.length;
        boolean fillFromJ = false;
        switch (mode) {
            case overlap: 
            case overlap_trim: {
                int index;
                int bestEdge = Integer.MIN_VALUE;
                for (index = 1; index < seqi.length + 1; ++index) {
                    if (scoringMatrix[index][seqj.length][0] <= bestEdge) continue;
                    bestEdge = scoringMatrix[index][seqj.length][0];
                    i = index;
                }
                for (index = 1; index < seqj.length + 1; ++index) {
                    if (scoringMatrix[seqi.length][index][0] <= bestEdge) continue;
                    bestEdge = scoringMatrix[seqi.length][index][0];
                    i = seqi.length;
                    j = index;
                    fillFromJ = true;
                }
                break;
            }
            case local: {
                int bestEdge = Integer.MIN_VALUE;
                for (int row = 1; row < seqi.length + 1; ++row) {
                    for (int col = 1; col < seqj.length + 1; ++col) {
                        if (scoringMatrix[row][col][0] <= bestEdge) continue;
                        bestEdge = scoringMatrix[row][col][0];
                        i = row;
                        j = col;
                    }
                }
                break;
            }
            case glocal: {
                int index;
                int bestEdge = Integer.MIN_VALUE;
                for (index = 1; index < seqi.length + 1; ++index) {
                    if (scoringMatrix[index][seqj.length][0] <= bestEdge) continue;
                    bestEdge = scoringMatrix[index][seqj.length][0];
                    i = index;
                }
                break;
            }
        }
        if (mode == AlignmentMode.overlap || mode == AlignmentMode.glocal) {
            StringBuffer appendGaps;
            StringBuffer appendBasesSeq;
            char[] appendBases;
            int x;
            if (fillFromJ) {
                x = j;
                appendBases = seqj;
                appendBasesSeq = alignedSeqj;
                appendGaps = alignedSeqi;
            } else {
                x = i;
                appendBases = seqi;
                appendBasesSeq = alignedSeqi;
                appendGaps = alignedSeqj;
            }
            for (int index = appendBases.length - 1; index >= x; --index) {
                appendBasesSeq.append(appendBases[index]);
                appendGaps.append('-');
                if (appendBases == seqi) {
                    scores.add(scoringMatrix[i][seqj.length][0]);
                    continue;
                }
                scores.add(scoringMatrix[seqi.length][j][0]);
            }
        }
        int endi = i;
        int endj = j;
        boolean done = false;
        block17: while (!done) {
            int traceVal = scoringMatrix[i][j][2];
            if (traceVal == 2) {
                alignedSeqi.append(seqi[i - 1]);
                alignedSeqj.append(seqj[j - 1]);
                --i;
                --j;
            } else if (traceVal == 1) {
                alignedSeqi.append('-');
                alignedSeqj.append(seqj[j - 1]);
                --j;
            } else if (traceVal == 0) {
                alignedSeqi.append(seqi[i - 1]);
                alignedSeqj.append('-');
                --i;
            } else {
                throw new IllegalArgumentException("Unknown trace value " + traceVal);
            }
            if (mode == AlignmentMode.local && scoringMatrix[i][j][0] < 0) {
                scores.add(0);
            } else {
                scores.add(scoringMatrix[i][j][0]);
            }
            switch (mode) {
                case global: {
                    done = i == 0 && j == 0;
                    continue block17;
                }
                case local: {
                    done = i == 0 && j == 0 || scoringMatrix[i][j][0] <= 0;
                    continue block17;
                }
                case overlap: 
                case overlap_trim: {
                    done = i == 0 || j == 0;
                    continue block17;
                }
                case glocal: {
                    done = i == 0;
                    continue block17;
                }
            }
            throw new IllegalArgumentException("Unknown alignment mode " + (Object)((Object)mode));
        }
        int starti = i;
        int startj = j;
        if (mode == AlignmentMode.overlap) {
            StringBuffer appendGaps;
            StringBuffer appendBasesSeq;
            char[] appendBases;
            int x;
            if (i == 0) {
                x = j;
                appendBases = seqj;
                appendBasesSeq = alignedSeqj;
                appendGaps = alignedSeqi;
            } else {
                x = i;
                appendBases = seqi;
                appendBasesSeq = alignedSeqi;
                appendGaps = alignedSeqj;
            }
            while (x > 0) {
                appendGaps.append('-');
                appendBasesSeq.append(appendBases[x - 1]);
                scores.add(0);
                --x;
            }
        }
        PairwiseAligner.reverse(alignedSeqi);
        PairwiseAligner.reverse(alignedSeqj);
        Collections.reverse(scores);
        return new PairwiseAlignment(alignedSeqi.toString().toUpperCase(), alignedSeqj.toString().toUpperCase(), scores, starti, endi, startj, endj);
    }

    public static PairwiseAlignment align(String seq1, String seq2, ScoringMatrix scoringMatrix, AlignmentMode mode) {
        int[][][] scores = PairwiseAligner.populateMatrix(seq1.toCharArray(), seq2.toCharArray(), scoringMatrix, mode);
        return PairwiseAligner.traceback(scores, seq1.toCharArray(), seq2.toCharArray(), mode);
    }
}

