/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReferenceSeqHelper {
    private Map<String, Map<Integer, Integer>> modelReferenceSeqMap = new HashMap<String, Map<Integer, Integer>>();
    private Map<String, String> referenceSeqMap = new HashMap<String, String>();

    public static ReferenceSeqHelper getInstance() {
        return ReferenceSeqHelperHolder.helper;
    }

    private ReferenceSeqHelper() {
        InputStream is = this.getClass().getResourceAsStream("/data/ref_seqs.fa");
        if (is == null) {
            throw new RuntimeException("Failed to find ref_seqs.fa in the data directory on the classpath");
        }
        try {
            Sequence seq;
            SequenceReader seqReader = new SequenceReader(is);
            while ((seq = seqReader.readNextSequence()) != null) {
                this.modelReferenceSeqMap.put(seq.getSeqName(), SeqUtils.generateReferenceSeqMapping(seq.getSeqString()));
                this.referenceSeqMap.put(seq.getSeqName(), seq.getDesc());
            }
            seqReader.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal error reading ref_seq.fa", e);
        }
    }

    public String getRefSeq(String model) {
        return this.referenceSeqMap.get(model);
    }

    public Set<String> getKnownModels() {
        return this.modelReferenceSeqMap.keySet();
    }

    public Map<Integer, Integer> getReferenceMap(String model) {
        return this.modelReferenceSeqMap.get(model);
    }

    public int translate(String model, int loc) {
        if (!this.modelReferenceSeqMap.containsKey(model)) {
            throw new IllegalArgumentException("Unknown model '" + model + "'");
        }
        if (!this.modelReferenceSeqMap.get(model).containsKey(loc)) {
            throw new IllegalArgumentException(loc + " isn't a model position");
        }
        return this.modelReferenceSeqMap.get(model).get(loc);
    }

    public int[] getEndPoints(String model, String seqString) {
        int[] modelEndPoints = SeqUtils.getSeqEndPoints(seqString);
        int refStart = this.translate(model, modelEndPoints[0]);
        int refEnd = this.translate(model, modelEndPoints[0]);
        return new int[]{refStart, refEnd};
    }

    private static class ReferenceSeqHelperHolder {
        private static ReferenceSeqHelper helper = new ReferenceSeqHelper();

        private ReferenceSeqHelperHolder() {
        }
    }
}

