/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.stat;

import java.util.ArrayList;
import java.util.Collections;

public class StdevCal {
    public static Std calStd(ArrayList<Double> valList) {
        double totalCount = 0.0;
        double valSum = 0.0;
        for (Double d : valList) {
            if (d.isNaN()) continue;
            valSum += d.doubleValue();
            totalCount += 1.0;
        }
        double mean = valSum / totalCount;
        double sum = 0.0;
        for (Double d : valList) {
            if (d.isNaN()) continue;
            sum += Math.pow(d - mean, 2.0);
        }
        double stdev = Math.sqrt(sum / (totalCount - 1.0));
        Std stdResult = new Std(totalCount, mean, stdev);
        return stdResult;
    }

    public static double calMean(ArrayList<Double> valList) {
        double totalCount = 0.0;
        double valSum = 0.0;
        for (Double d : valList) {
            if (d.isNaN()) continue;
            valSum += d.doubleValue();
            totalCount += 1.0;
        }
        if (totalCount == 0.0) {
            return 0.0;
        }
        return valSum / totalCount;
    }

    public static double calMedian(ArrayList<Double> valList) {
        Collections.sort(valList);
        int middle = valList.size() / 2;
        double medianValue = 0.0;
        medianValue = valList.size() % 2 == 1 ? valList.get(middle) : (valList.get(middle - 1) + valList.get(middle)) / 2.0;
        return medianValue;
    }

    public static void main(String[] args) {
        ArrayList<Double> valList = new ArrayList<Double>();
        valList.add(5.0);
        valList.add(12.0);
        valList.add(16.0);
        valList.add(21.0);
        valList.add(14.0);
        valList.add(15.0);
        Std result = StdevCal.calStd(valList);
        System.out.println("totalCount= " + result.totalCount + " mean= " + result.mean + " std=" + result.stdev);
        System.out.println("mean " + StdevCal.calMean(valList));
        System.out.println("median " + StdevCal.calMedian(valList));
    }

    public static class Std {
        private double totalCount;
        private double mean;
        private double stdev;

        Std(double t, double m, double s) {
            this.totalCount = t;
            this.mean = m;
            this.stdev = s;
        }

        public double getTotalCount() {
            return this.totalCount;
        }

        public double getMean() {
            return this.mean;
        }

        public double getStdev() {
            return this.stdev;
        }
    }
}

