% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track_bedgraph_matrix}
\alias{track_bedgraph_matrix}
\title{Generate bedgraph matrix track}
\usage{
track_bedgraph_matrix(
  file,
  title = NULL,
  height = 2,
  overlay_previous = "no",
  orientation = NULL,
  max_value = NULL,
  min_value = NULL,
  show_data_range = FALSE,
  type = "matrix",
  rasterize = TRUE,
  pos_score_in_bin = "center",
  plot_horizontal_lines = FALSE,
  colormap = "virdis"
)
}
\arguments{
\item{file}{String. The location of the track file}

\item{title}{String. If specificed, the title of the track to be displayed.}

\item{height}{Numeric. The height of the plotted track in cm.}

\item{overlay_previous}{String. Options are "no" (default) or "yes" or}

\item{orientation}{String. Set to "inverted" to make the track upside down. Default is NULL.}

\item{max_value}{Numeric. Default is NULL.
The max value cut-off for the numeric column.}

\item{min_value}{Numeric. Default is NULL.
The min value cut-off for the numeric column.}

\item{show_data_range}{Boolean. Default is FALSE.}

\item{type}{"matrix" (default) or "lines".}

\item{rasterize}{Boolean. Default is TRUE}

\item{pos_score_in_bin}{String value to indicate the position of score with respect to bin start and end.
Possible values are either "center" (default) or "block".}

\item{plot_horizontal_lines}{Boolean. Can be used only if type parameter is set to "lines".}

\item{colormap}{String with matplotlib-compatible colormap. Default is set to "viridis".}
}
\value{
genome_track
}
\description{
A track for file like bedgraph but with more than 4 columns, like the insulation score from hicPlotTADs
}
\details{
The different options for color maps can be found here: https://matplotlib.org/users/colormaps.html.
}
\note{
\code{fontsize} argument can be overriden by the same argument in \code{plot_gtracks()}
}
\examples{
IS_dir <- system.file("extdata", package = "rGenomeTracks", "tad_separation_score.bm.gz")
IS <- track_bedgraph_matrix(IS_dir)
\dontrun{
plot_gtracks(IS, chr = "X", start = 2000000, end = 3500000)
}
}
\author{
Omar Elashkar
}
