% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track_bed}
\alias{track_bed}
\title{Generate bed track}
\usage{
track_bed(
  file,
  title = NULL,
  height = 2,
  overlay_previous = "no",
  fontsize = 12,
  orientation = NULL,
  line_width = 0.5,
  color = "#1f78b4",
  max_value = NULL,
  min_value = NULL,
  border_color = "black",
  prefered_name = "transcript_name",
  merge_transcripts = FALSE,
  labels = TRUE,
  style = "flybase",
  display = "stacked",
  max_labels = 60,
  global_max_row = FALSE,
  gene_rows = NULL,
  arrow_interval = 2,
  arrowhead_included = FALSE,
  color_utr = 0,
  height_utr = 1,
  arrow_length = 0,
  all_labels_inside = FALSE,
  labels_in_margin = FALSE
)
}
\arguments{
\item{file}{String. The location of the track file}

\item{title}{String. If specificed, the title of the track to be displayed.}

\item{height}{Numeric. The height of the plotted track in cm. Default is 2.
See notes.}

\item{overlay_previous}{String. Options are "no" (default) or "yes" or
"share-y".}

\item{fontsize}{Numeric value to font size of tracks's text.}

\item{orientation}{String. Set to "inverted" to make the track upside down.
Default is NULL.}

\item{line_width}{Numeric. Default is 0.5.}

\item{color}{String. Hex color or string color. Default is "#1f78b4".}

\item{max_value}{Numeric. Default is NULL. The max value cut-off for the
numeric column.}

\item{min_value}{Numeric. Default is NULL. The max value cut-off for the
numeric column.}

\item{border_color}{String. default is "black"}

\item{prefered_name}{String. Denote which column to get elements names.
Default is "transcript_name".}

\item{merge_transcripts}{Boolean. Default is FALSE.}

\item{labels}{Boolean. Default is FALSE.}

\item{style}{String. Options are "flybase" (default), or "UCSV" or
"tassarrow".}

\item{display}{String. options are "stacked" (default) or "collapsed",
"triangles" or "interleaved".}

\item{max_labels}{Numeric. Any integer about 1. Default is 60.}

\item{global_max_row}{Boolean. Default is FALSE.}

\item{gene_rows}{Numeric. Default is NULL.}

\item{arrow_interval}{Numeric. Should be above 1. Default is 2}

\item{arrowhead_included}{Boolean. Default is FALSE}

\item{color_utr}{String. Hex color or string. Default is "grey"}

\item{height_utr}{Numeric. Between 0 and 1. Default is 1.}

\item{arrow_length}{Numeric. Default is NULL.}

\item{all_labels_inside}{Boolean. Default is FALSE}

\item{labels_in_margin}{Boolean. Default is FALSE.}
}
\value{
genome_track
}
\description{
Generate genome_track object from a bed file.
}
\details{
\code{track_bed()} supports all common bed files with minimal of
3 columns and maximum of 12 columns.
}
\note{
\code{fontsize} argument can be overriden by the same
argument in \code{plot_gtracks()}
}
\examples{
bed12_dir <- system.file("extdata", "dm3_genes.bed.gz",
  package = "rGenomeTracks"
)
bed4_dir <- system.file("extdata", "dm3_genes.bed4.gz",
  package = "rGenomeTracks"
)
bed6_dir <- system.file("extdata", "dm3_genes.bed6.gz",
  package = "rGenomeTracks"
)

# Create bed track using bed4 file
bed4 <- track_bed(
  file = bed4_dir, height = 3, title = "bed4", color = "cyan", ,
  border_color = "#9ACD32", line_width = 1.5
)

# Create bed track using bed6 file
bed6 <- track_bed(
  file = bed6_dir, height = 3, title = "bed4", fontsize = 8, color = "red",
  border_color = "yellow", arrowhead_included = TRUE
)

# Create bed track using bed12 file
bed12 <- track_bed(
  file = bed12_dir, height = 3, title = "bed12", style = "UCSC",
  arrow_interval = 10, fontsize = 10
)

# Create a spacer track
space <- track_spacer(height = 1)
\dontrun{
# Plotting the tracks
plot_gtracks(bed4 + space + bed6 + space + bed12 + space,
  chr = "X", start = 300 * 10^4, end = 330 * 10^4, verbose = TRUE
)
}
}
\author{
Omar Elashkar
}
