% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeIntensity-functions.R
\name{scaleCols}
\alias{scaleCols}
\title{Scale along columns (samples)}
\usage{
scaleCols(
  x,
  type = c("div.sum", "div.mean", "div.median", "div.mad"),
  restrict = FALSE,
  rescale = FALSE
)
}
\arguments{
\item{x}{A matrix-like object.}

\item{type}{A scaling method to use.}

\item{restrict}{A logical specifying whether only features that are common
to all samples are used in the calculation of scaling factors.}

\item{rescale}{A logical specifying whether the normalized intensities are
re-scaled by multiplying the median of normalization factors to make look
similar to the original scale.}
}
\value{
A matrix of the same dimension as \code{x} containing the scaled
intensities.
}
\description{
Function to scale a matrix of intensity data along the columns (samples).
}
\details{
Sample intensities are divided by the column sums ("div.sum"), means
("div.mean"), medians ("div.median"), or median absolute deviations
("div.mad").
}
\examples{

data(faahko_se)

m <- assay(faahko_se, "knn")
scaleCols(m)

}
\seealso{
See \link{normalizeIntensity} that provides a
\linkS4class{SummarizedExperiment}-friendly wrapper for this function.
}
