% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceFeatures-functions.R
\name{reducePLSDA}
\alias{reducePLSDA}
\title{Partial least squares-discriminant analysis (PLS-DA)}
\usage{
reducePLSDA(
  x,
  y,
  ncomp = 2,
  center = TRUE,
  scale = FALSE,
  validation = c("none", "CV", "LOO"),
  return_mvr = FALSE,
  ...
)
}
\arguments{
\item{x}{A matrix-like object.}

\item{y}{A factor vector for the information about each sample's group.}

\item{ncomp}{A integer specifying the number of components to extract.}

\item{center}{A logical specifying whether \code{x} and \code{y} matrices need to be
mean-centered prior to PLS-DA.}

\item{scale}{A logical specifying whether the unit variance scaling needs to
be performed on \code{x} prior to PLS-DA.}

\item{validation}{A string specifying a validation method to use. See
\link[pls:mvr]{pls::plsr} for the details.}

\item{return_mvr}{A logical indicating whether \code{mvr} object is returned.
It is recommended for a user to use utilities functions from the \code{pls}
package for the model fit.}

\item{...}{Additional arguments passed to \link[pls:mvr]{pls::plsr}.}
}
\value{
A reduced.plsda object with the same number of rows as
\code{ncol(x)} containing the dimension reduction result.
}
\description{
Performs PLS-DA on a matrix-like object where rows represent features and
columns represent samples.
}
\details{
This function performs standard PLS for classification with the transpose of
\code{x} using the \link[pls:mvr]{pls::plsr}. Since PLS-DA is a supervised method, users must
supply the information about each sample's group. Here, \code{y} must be a factor
so that it can be internally converted to an indicator matrix. The function
returns a \code{reduced.plsda} object that is a matrix with custom attributes to
summarize (via \link{summary}) and visualize (via \link{plotReduced}) the PLS-DA
result. The custom attributes include the following:
\itemize{
\item \code{method}: The method used to reduce the dimension of data.
\item \code{ncomp}: The number of components extracted.
\item \code{explvar}: A vector indicating the amount of X variance explained by
each component.
\item \code{responses}: A vector indicating the levels of factor \code{y}.
\item \code{predictors}: A vector of predictor variables.
\item \code{coefficient}: An array of regression coefficients.
\item \code{loadings}: A matrix of loadings.
\item \code{loadings.weights}: A matrix of loading weights.
\item \code{Y.observed}: A vector of observed responses.
\item \code{Y.predicted}: A vector of predicted responses.
\item \code{Y.scores}: A matrix of Y-scores.
\item \code{Y.loadings}: A matrix of Y-loadings.
\item \code{projection}: The projection matrix.
\item \code{fitted.values}: An array of fitted values.
\item \code{residuals}: An array of regression residuals.
\item \code{vip}: An array of VIP (Variable Importance in the Projection)
coefficients.
\item \code{centered}: A logical indicating whether the data was mean-centered prior
to PLS-DA.
\item \code{scaled}: A logical indicating whether the data was scaled prior to
PLS-DA.
\item \code{validation}: Results of the validation if requested.
}
}
\examples{

data(faahko_se)

m <- assay(faahko_se, "knn_vsn")
y <- factor(colData(faahko_se)$sample_group)
res <- reducePLSDA(m, y = y)
summary(res)
}
\references{
Kristian Hovde Liland, Bjørn-Helge Mevik and Ron Wehrens (2021). pls:
Partial Least Squares and Principal Component Regression. R package version
2.8-0. https://CRAN.R-project.org/package=pls
}
\seealso{
See \link{reduceFeatures} that provides a
\linkS4class{SummarizedExperiment}-friendly wrapper for this function.

See \link{plotReduced} for visualization.

See \link[pls:mvr]{pls::plsr} for the underlying function that does the work.
}
