% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotReduced.R
\name{plotReduced}
\alias{plotReduced}
\title{Score plot of dimension-reduced data}
\usage{
plotReduced(
  x,
  comp = c(1, 2),
  biplot = FALSE,
  group,
  group_col = NULL,
  point_size = 1.5,
  point_shape_by_group = FALSE,
  label = FALSE,
  label_size = 3.88,
  label_subset = NULL,
  ellipse = FALSE,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  legend = TRUE,
  arrow_len = 0.2,
  arrow_col = "orange",
  arrow_alpha = 0.3,
  arrow_label = TRUE,
  arrow_label_ext = 1.05,
  arrow_label_size = 3.88,
  arrow_label_col = "orange",
  arrow_label_subset = NULL
)
}
\arguments{
\item{x}{A matrix containing the dimension-reduced data typically produced
by \link{reduceFeatures}.}

\item{comp}{A numeric vector of length 2 specifying the components to
display.}

\item{biplot}{A logical specifying whether visualize an overlay of scores
and loadings. Ignored if \code{x}is not a \code{reduced.pca} or \code{reduced.plsda}
object.}

\item{group}{A discrete variable to visualize the grouping structure. For a
\code{reduced.plsda} object, group information used to fit the PLS-DA is used
if not specified.}

\item{group_col}{A vector of colors with the same length of unique values in
\code{group}.}

\item{point_size}{A numeric value specifying the size of points.}

\item{point_shape_by_group}{A logical specifying whether each group has
different shapes of data points. Also can be a numeric vector with the
same length of unique values in \code{group} to manually set point shapes.}

\item{label}{A logical specifying whether score labels are shown instead of
points.}

\item{label_size}{A numeric value controlling the size of labels.}

\item{label_subset}{A character vector specifying a subset of score labels
to display.}

\item{ellipse}{A logical specifying whether data ellipses are shown.}

\item{xlab}{A string specifying the title of x-axis.}

\item{ylab}{A string specifying the title of y-axis.}

\item{title}{A string specifying the main title of the plot.}

\item{legend}{A logical specifying whether the plot legend is shown.}

\item{arrow_len}{A numeric value specifying the length of arrow head.}

\item{arrow_col}{A string specifying the color of arrows.}

\item{arrow_alpha}{A numeric value specifying the transparency of arrow.}

\item{arrow_label}{A logical specifying whether text labels for arrows are
shown.}

\item{arrow_label_ext}{A numeric value specifying the scalar extension for
arrow labels.}

\item{arrow_label_size}{A numeric value specifying the size of arrow labels.}

\item{arrow_label_col}{A string specifying the color of arrow labels.}

\item{arrow_label_subset}{A character vector specifying a subset of arrow
labels to display.}
}
\value{
A ggplot object.
}
\description{
Function to visualize dimension-reduced data matrices mainly produced by
\link{reduceFeatures}, including \code{reduced.pca}, \code{reduced.tsne}, and
\code{reduced.plsda} objects (or a matrix with the same structure).
}
\examples{

data(faahko_se)

## Sample group
g <- colData(faahko_se)$sample_group

## PCA
pca_res <- reduceFeatures(faahko_se, i = "knn_vsn", method = "pca")

## Visualizes the result
plotReduced(pca_res, group = g)
plotReduced(pca_res, group = g, label = TRUE, ellipse = TRUE)

}
