% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeScaling.R
\name{normalizeScaling}
\alias{normalizeScaling}
\title{Normalization by scaling}
\usage{
normalizeScaling(MSnSetObj, scalingFunction = median, ProteinId = NULL)
}
\arguments{
\item{MSnSetObj}{MSnSet; an object of class MSnSet}

\item{scalingFunction}{function; median or mean}

\item{ProteinId}{character; protein Id}
}
\value{
An object of class \code{MSnSet} (see \code{\link{MSnSet-class}})
}
\description{
Performs scaling normalization on the peptide/protein intensities (median or
mean)
}
\details{
In this normalization method the central tendencies (mean or median) of the
samples are aligned.  The central tendency for each sample is computed and
log transformed. A scaling factor is determined by subtracting from each
central tendency the mean of all the central tendencies.  The raw intensities
are then divided by the scaling factor to get normalized intensities.

The intensities can also be normalized based on the peptide intensities of
a selected protein. For this the argument "ProteinId" allows you to define
the protein that will be used for scaling the intensities.
}
\examples{

data(human_anno)
data(exp3_OHT_ESR1)
MSnSet_data <- convertToMSnset(exp3_OHT_ESR1$intensities_qPLEX1, 
                               metadata=exp3_OHT_ESR1$metadata_qPLEX1,
                               indExpData=c(7:16), 
                               Sequences=2, 
                               Accessions=6)
MSnset_norm <- normalizeScaling(MSnSet_data, scalingFunction=median)

}
