% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{analysesTableSet}
\alias{analysesTableSet}
\alias{processClickRedirection}
\alias{analysesPlotSet}
\title{Set of functions to render differential analyses (plot and table)}
\usage{
analysesTableSet(
  session,
  input,
  output,
  analysesType,
  analysesID,
  getAnalysesData,
  getAnalysesFiltered,
  setAnalysesFiltered,
  getAnalysesSurvival,
  getAnalysesColumns,
  setAnalysesColumns,
  getResetPaging,
  setResetPaging
)

processClickRedirection(click, psi = NULL, survival = FALSE)

analysesPlotSet(
  session,
  input,
  output,
  analysesType,
  analysesID,
  getAnalysesData,
  getAnalysesFiltered,
  getAnalysesSurvival
)
}
\arguments{
\item{session}{Shiny session}

\item{input}{Shiny input}

\item{output}{Shiny output}

\item{analysesType}{Character: type of analyses (\code{GE} or \code{PSI})}

\item{analysesID}{Character: identifier}

\item{getAnalysesData}{Function: get analyses data}

\item{getAnalysesFiltered}{Function: get filtered analyses data}

\item{setAnalysesFiltered}{Function: set filtered analyses data}

\item{getAnalysesSurvival}{Function: get survival data}

\item{getAnalysesColumns}{Function: get columns}

\item{setAnalysesColumns}{Function: set columns}

\item{getResetPaging}{Function: get toggle of reset paging}

\item{setResetPaging}{Function: set toggle of reset paging}

\item{click}{List: click information}

\item{psi}{Data frame or matrix: alternative splicing quantification}

\item{survival}{Boolean: redirect to survival page?}
}
\value{
\code{NULL} (function is only used to modify the Shiny session's
state or internal variables)
}
\description{
Set of functions to render differential analyses (plot and table)

Set up environment and redirect user to a page based on click information
}
\keyword{internal}
