% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/clusterPlotR.R
\docType{methods}
\name{clusterPlotR}
\alias{clusterPlotR}
\alias{clusterPlotR,ANY,kmeans-method}
\alias{clusterPlotR,ANY,hclust-method}
\title{Generic clusterPlotR function}
\usage{
clusterPlotR(cData, cls, x, NC, ...)

\S4method{clusterPlotR}{ANY,kmeans}(
  cData = NA,
  cls = NA,
  x = NA,
  NC = NA,
  annoIndx = NA,
  label = NULL,
  ...
)

\S4method{clusterPlotR}{ANY,hclust}(
  cData = NA,
  cls = NA,
  x = NA,
  NC = NA,
  annoIndx = NA,
  label = NULL,
  ...
)
}
\arguments{
\item{cData}{data used to get clusters}

\item{cls}{a cluster (kmeans or hclust) object}

\item{x}{a vector of length equal to number of samples to use for plotting}

\item{NC}{vector of integers indicating which clusters to use}

\item{...}{additional parameters for plotting. ex. pch,cex,col,labels, xlab, etc.}

\item{annoIndx}{vector indexing into subsets for plotting}

\item{label}{character vector to use for plotting text, defaults is NULL}
}
\value{
A plot of the mean behavior for each cluster
}
\description{
plotting function for clustering objects
}
\examples{
\dontrun{
 k.RNAseq6l3c3t<-kmeans(p.RNAseq6l3c3t,22)
 clusterPlotR(p.RNAseq6l3c3t, cls=k.RNAseq6l3c3t,NC=1,x=pd.RNAseq6l3c3t$days,
col=pd.RNAseq6l3c3t$color)
}
}
