% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation-data.R
\name{preparePromoterAnnotation}
\alias{preparePromoterAnnotation}
\title{Prepares promoter annotation from a gtf or txdb}
\usage{
preparePromoterAnnotation(txdb, file, species)
}
\arguments{
\item{txdb}{A txdb object. The txdb of the annotation version for which
promoters will be identified. Either `txdb` or `file` argument must be 
specified, but not both.}

\item{file}{A character object. The file path to a gtf/gff or txdb of the 
annotation version for which promoters will be identified. Either `txdb` 
or `file` argument must be specified, but not both.}

\item{species}{A character object. The genus and species of the organism to
be used in keepStandardChromosomes(). Supported species can be seen with
names(genomeStyles()).}
}
\value{
A PromoterAnnotation object. The annotated
  intron ranges, promoter coordinates and the promoter id mapping are
  attributes of the promoter annotation data.
}
\description{
Prepares promoter annotation from a gtf or txdb
}
\examples{

txdbPath <- system.file('extdata/vignette/annotations/',
                            'gencode.v34.annotation.subset.sqlite', 
                             package = 'proActiv')
txdb <- AnnotationDbi::loadDb(txdbPath)
promoterAnnotation <- preparePromoterAnnotation(txdb = txdb,
                                                species = 'Homo_sapiens')

}
