% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glog_transformation.R
\name{glog_plot_optimised_lambda}
\alias{glog_plot_optimised_lambda}
\title{Plot SSE error of lambda optimisation process}
\usage{
glog_plot_optimised_lambda(
  df,
  optimised_lambda,
  classes,
  qc_label,
  plot_grid = 100
)
}
\arguments{
\item{df}{A matrix-like (e.g. an ordinary matrix, a data frame) or 
\link[SummarizedExperiment]{RangedSummarizedExperiment-class} object with 
all values of class \code{numeric()} or \code{integer()} of peak 
intensities, areas or other quantitative characteristic.}

\item{optimised_lambda}{\code{numeric(1)}, value of optimised lambda from 
glog_transformation output.}

\item{classes}{\code{character()}, vector of class labels. Must be the same 
length as the number of sample in the input peak table. If input is 
\code{SummarizedExperiment} object, use 
\code{SummarizedExperiment_object$meta_data_column_name}.}

\item{qc_label}{\code{character(1)} or \code{NULL}, class label used to
identify QC samples.}

\item{plot_grid}{\code{integer(1)}, number of data points to use for SSE 
optimisation.}
}
\value{
Class \code{ggplot} object containing optimisation plot.
}
\description{
Plot SSE error of lambda optimisation process
}
\examples{
data <- MTBLS79[, MTBLS79$Batch == 1]
classes <- data$Class

data <- mv_imputation(df=data, method='knn')
out <- glog_transformation (df=data, classes=classes,
    qc_label='QC')

optimised_lambda <- S4Vectors::metadata(out)
optimised_lambda <- 
    optimised_lambda$processing_history$glog_transformation$lambda_opt

glog_plot_optimised_lambda(df=data, classes=classes,
    qc_label="QC", optimised_lambda=optimised_lambda)
}
