% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbc_main.R
\name{QCRSC}
\alias{QCRSC}
\title{Quality Control-Robust Spline Correction (QC-RSC)}
\usage{
QCRSC(
  df,
  order,
  batch,
  classes,
  spar = 0,
  log = TRUE,
  minQC = 5,
  qc_label = "QC",
  spar_lim = c(-1.5, 1.5)
)
}
\arguments{
\item{df}{A matrix-like (e.g. an ordinary matrix, a data frame) or 
\link[SummarizedExperiment]{RangedSummarizedExperiment-class} object with 
all values of class \code{numeric()} or \code{integer()} of peak 
intensities, areas or other quantitative characteristic.}

\item{order}{\code{numeric()}, A numeric vector indicating the order in 
which samples were measured.}

\item{batch}{\code{numeric()} or \code{character()}, a vector indicating
the batch each sample was measured in. If only one batch was measured then
all values should be set to 1}

\item{classes}{\code{character()}, vector of class labels. Must be the same 
length as the number of sample in the input peak table. If input is 
\code{SummarizedExperiment} object, use 
\code{SummarizedExperiment_object$meta_data_column_name}.}

\item{spar}{\code{numeric(1)}, Spline smoothing parameter. Should be in the 
range 0 to 1. If set to 0 it will be estimated using leave-one-out 
cross-validation.}

\item{log}{\code{logical(1)}, to perform the signal correction fit on the
log scaled data. Default is TRUE.}

\item{minQC}{\code{integer(1)}, Minimum number of measured quality control
(QC) samples required for signal correction within feature per batch. For 
features where signal was measured in less QC samples than threshold signal
correction won't be applied.}

\item{qc_label}{\code{character(1)} or \code{NULL}, class label used to
identify QC samples.}

\item{spar_lim}{A 2 element numeric vector containing the min and max
values of spar when searching for an optimum. Default \code{spar_lim = c(-1.5,1.5)}}
}
\value{
Object of class \code{SummarizedExperiment}. If input data are a 
matrix-like (e.g. an ordinary matrix, a data frame) object, function returns 
the same R data structure as input with all value of data type 
\code{numeric()}.
}
\description{
Implementation of Quality QC-RSC algorithm for signal drift and batch 
effect correction within/across a multi-batch direct infusion mass
spectrometry (DIMS) and liquid chromatography mass spectrometry (LCMS)
datasets.
This version supports missing values, but requires at least 4 data point 
for quality control (QC) samples measured within each analytical batch.
The smoothing parameter (spar) can be optimised using leave-one-out cross
validation to avoid overfitting.
}
\examples{
classes <- MTBLS79$Class
batch <- MTBLS79$Batch
order <- c(1:ncol(MTBLS79))

out <- QCRSC(df = MTBLS79[1:10, ], order = order, batch = MTBLS79$Batch,
classes = MTBLS79$Class, spar = 0, minQC = 4)

}
\references{
Kirwan et al, Anal. Bioanal. Chem., 405 (15), 2013
\url{https://dx.doi.org/10.1007/s00216-013-6856-7}
}
\author{
Andris Jankevics \email{a.jankevics@bham.ac.uk}
}
