% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_data.R
\name{group-group_data}
\alias{group-group_data}
\alias{group_data.GroupedGInteractions}
\alias{group_keys.GroupedGInteractions}
\alias{group_indices.GroupedGInteractions}
\alias{group_vars.GInteractions}
\alias{group_vars.GroupedGInteractions}
\alias{groups.GroupedGInteractions}
\alias{group_size.GroupedGInteractions}
\alias{n_groups.GroupedGInteractions}
\title{GInteractions grouping metadata}
\usage{
\method{group_data}{GroupedGInteractions}(.data)

\method{group_keys}{GroupedGInteractions}(.tbl, ...)

\method{group_indices}{GroupedGInteractions}(.data, ...)

\method{group_vars}{GInteractions}(x)

\method{group_vars}{GroupedGInteractions}(x)

\method{groups}{GroupedGInteractions}(x)

\method{group_size}{GroupedGInteractions}(x)

\method{n_groups}{GroupedGInteractions}(x)
}
\arguments{
\item{.data, .tbl, x}{a GInteractions object}

\item{...}{Ignored.}
}
\value{
a GInteractions object.
}
\description{
GInteractions grouping metadata
}
\examples{
gi <- read.table(text = "
chr1 11 20 chr1 21 30
chr1 11 20 chr1 51 55
chr1 11 30 chr1 51 55
chr1 11 30 chr2 51 60",
col.names = c(
    "seqnames1", "start1", "end1", 
    "seqnames2", "start2", "end2")
) |> 
  as_ginteractions() |> 
  mutate(type = c('cis', 'cis', 'cis', 'trans'), score = runif(4))

ggi <- gi |> group_by(end1)
ggi
group_data(ggi)
group_keys(ggi)
group_rows(ggi)
group_indices(ggi)
group_vars(ggi)
groups(ggi)
group_size(ggi)
n_groups(ggi)
}
