% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ginteractions-construct.R
\name{as_ginteractions}
\alias{as_ginteractions}
\title{Construct a GInteractions object from a tibble, DataFrame or data.frame}
\usage{
as_ginteractions(
  .data,
  ...,
  keep.extra.columns = TRUE,
  starts.in.df.are.0based = FALSE
)
}
\arguments{
\item{.data}{A \code{\link[=data.frame]{data.frame()}}, \code{\link[=DataFrame]{DataFrame()}} or \code{tibble()} to
construct a GInteractions object from.}

\item{...}{Optional named arguments specifying which the columns in .data
containin the core components a GInteractions object.}

\item{keep.extra.columns}{TRUE or FALSE (the default). If TRUE, the columns
in df that are not used to form the genomic ranges of the returned GRanges
object are then returned as metadata columns on the object. Otherwise, they
are ignored.}

\item{starts.in.df.are.0based}{TRUE or FALSE (the default). If TRUE, then
the start positions of the genomic ranges in df are considered to be
0-based and are converted to 1-based in the returned GRanges object.}
}
\value{
a GInteractions object.
}
\description{
The \code{as_ginteractions} function looks for column names in
.data called seqnames\{1,2\}, start\{1,2\}, end\{1,2\}, and strand\{1,2\}
in order to construct a GInteractions object.
By default other columns in .data are placed into the mcols (metadata
columns) slot of the returned object.
}
\examples{
####################################################################
# 1. GInteractions from bedpe files imported into a data.frame
####################################################################

bedpe <- read.table(text = "
chr1 100 200 chr1 5000 5100 bedpe_example1 30 + -
chr1 1000 5000 chr1 3000 3800 bedpe_example2 100 + -",
col.names = c(
  "chrom1", "start1", "end1", 
  "chrom2", "start2", "end2", "name", "score", "strand1", "strand2"))
bedpe |> 
  as_ginteractions(seqnames1 = chrom1, seqnames2 = chrom2)

####################################################################
# 2. GInteractions from standard pairs files imported into a data.frame
####################################################################

# Note how the pairs are 0-based and no "end" field is provided 
# (the standard pairs file format does not have "end" fields)
# We can provide width1 and width2 to fix this problem. 

pairs <- read.table(text = "
pair1 chr1 10000 chr1 20000 + +
pair2 chr1 50000 chr1 70000 + +
pair3 chr1 60000 chr2 10000 + +
pair4 chr1 30000 chr3 40000 + -", 
col.names = c(
  "pairID", "chr1", "pos1", "chr2", "pos2", "strand1", "strand2")
)
pairs |> 
  as_ginteractions(
    seqnames1 = chr1, start1 = pos1, width1 = 1000, 
    seqnames2 = chr2, start2 = pos2, width2 = 1000, 
    starts.in.df.are.0based = TRUE
  )

####################################################################
# 3. GInteractions from data.frame with extra fields
####################################################################

df <- read.table(text = "
chr1 100 200 chr1 5000 5100
chr1 1000 5000 chr1 3000 3800",
col.names = c("chr1", "start1", "end1", "chr2", "start2", "end2"))
df |> 
  as_ginteractions(seqnames1 = chr1, seqnames2 = chr2)

df <- read.table(text = "
chr1 100 200 chr1 5000 5100
chr1 1000 5000 chr1 3000 3800",
col.names = c("chr1", "start1", "end1", "chr2", "start2", "end2"))
df |> 
  as_ginteractions(
    seqnames1 = chr1, seqnames2 = chr2, strand1 = '+', strand2 = '-'
  )

data.frame(type = "cis", count = 3) |> 
  as_ginteractions(
    seqnames1 = 'chr1', start1 = 1, end1 = 10,
    seqnames2 = 'chr1', start2 = 40, end2 = 50
  )

####################################################################
# 4. GInteractions from a real like pairs files
####################################################################

pairsf <- system.file('extdata', 'pairs.gz', package = 'plyinteractions')
pairs <- read.table(pairsf, comment.char = '#', header = FALSE)
head(pairs)
pairs |> 
  as_ginteractions(
    seqnames1 = V2, start1 = V3, width1 = 1, strand1 = V6, 
    seqnames2 = V4, start2 = V5, width2 = 1, strand2 = V7,
    starts.in.df.are.0based = TRUE
  )
}
\seealso{
\code{\link[InteractionSet:GInteractions-class]{InteractionSet::GInteractions()}}
}
