% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{dplyr-select}
\alias{dplyr-select}
\alias{select.GInteractions}
\title{Select columns within GInteractions metadata columns}
\usage{
\method{select}{GInteractions}(.data, ..., .drop_ranges = FALSE)
}
\arguments{
\item{.data}{a GInteractions object}

\item{...}{Integer indicating rows to keep.}

\item{.drop_ranges}{if TRUE, returns a DataFrame object. In this case, it
enables selection of any column including core GInteractions columns.}
}
\value{
a GInteractions object.
}
\description{
Select columns within GInteractions metadata columns
}
\examples{
gi <- read.table(text = "
chr1 1 10 chr1 1 10
chr2 1 10 chr2 1 10
chr3 1 10 chr3 1 10
chr4 1 10 chr4 1 10
chr5 1 10 chr5 1 10",
col.names = c(
    "seqnames1", "start1", "end1", 
    "seqnames2", "start2", "end2")
) |> 
  as_ginteractions() |> 
  mutate(score = runif(5)*100, cis = TRUE, gc = runif(5))
  
####################################################################
# 1. Select metadata columns from GInteractions by index
####################################################################

gi |> select(2, 1)
gi |> select(-3)

####################################################################
# 2. Select metadata columns from GInteractions by name
####################################################################

gi |> select(gc, score)

####################################################################
# 3. Select metadata columns from GInteractions with <tidy-select>
####################################################################

gi |> select(contains('s'))
gi |> select(matches('^s'))

####################################################################
# 4. Select core and metadata columns with .drop_ranges = TRUE
####################################################################

gi |> select(matches('^s'), .drop_ranges = TRUE)

}
