% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_by.R
\name{dplyr-group_by}
\alias{dplyr-group_by}
\alias{group_by.GInteractions}
\alias{group_by.DelegatingGInteractions}
\alias{ungroup.GroupedGInteractions}
\title{Group GInteractions by columns}
\usage{
\method{group_by}{GInteractions}(.data, ..., .add = FALSE)

\method{group_by}{DelegatingGInteractions}(.data, ..., .add = FALSE)

\method{ungroup}{GroupedGInteractions}(x, ...)
}
\arguments{
\item{.data, x}{a (Grouped)GInteractions object}

\item{...}{Column(s) to group by.}

\item{.add}{When FALSE, the default, group_by() will override existing
groups. To add to the existing groups, use .add = TRUE.}
}
\value{
a \code{GroupedGInteractions} object. When a
\verb{(Anchored)PinnedGInteractions} object is grouped, both anchoring and
pinning are dropped.
}
\description{
Group GInteractions by columns
}
\examples{
gi <- read.table(text = "
chr1 11 20 chr1 21 30
chr1 11 20 chr1 51 55
chr1 11 30 chr1 51 55
chr1 11 30 chr2 51 60",
col.names = c(
    "seqnames1", "start1", "end1", 
    "seqnames2", "start2", "end2")
) |> 
  as_ginteractions() |> 
  mutate(type = c('cis', 'cis', 'cis', 'trans'), score = runif(4))

####################################################################
# 1. Group by core column
####################################################################

gi |> group_by(end1)

gi |> group_by(end1, end2) |> group_data()

####################################################################
# 2. Group by metadata column
####################################################################

gi |> group_by(type) |> group_data()

####################################################################
# 3. Combine core and metadata column grouping
####################################################################

gi |> group_by(end1, type)
gi |> group_by(end1, type) |> group_data()

####################################################################
# 4. Create a new column and group by this new variable
####################################################################

gi |> group_by(class = c(1, 2, 1, 2))

####################################################################
# 5. Replace or add groups to a GroupedGInteractions
####################################################################

ggi <- gi |> group_by(class = c(1, 2, 1, 2))
ggi |> group_data()
ggi |> group_by(type) |> group_data()
ggi |> group_by(type, .add = TRUE) |> group_data()

####################################################################
# 6. Ungroup GInteractions
####################################################################

ggi <- gi |> group_by(type, class = c(1, 2, 1, 2))
ggi
ungroup(ggi, type)
ungroup(ggi, class)

}
