% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange.R
\name{dplyr-arrange}
\alias{dplyr-arrange}
\alias{arrange.GInteractions}
\title{Arrange a GInteractions by a column}
\usage{
\method{arrange}{GInteractions}(.data, ...)
}
\arguments{
\item{.data}{a GInteractions object}

\item{...}{\if{html}{\out{<data-masking>}} Variables, or functions of variables.
Use dplyr::desc() to sort a variable in descending order.}
}
\value{
a GInteractions object.
}
\description{
Arrange a GInteractions by a column
}
\examples{
gi <- read.table(text = "
chr1 1 10 chr1 1 10
chr1 2 10 chr2 1 10
chr3 3 10 chr3 1 10
chr4 4 10 chr4 1 10
chr5 5 10 chr5 1 10",
col.names = c(
  "seqnames1", "start1", "end1", 
  "seqnames2", "start2", "end2")
) |> 
  as_ginteractions() |> 
  mutate(cis = seqnames1 == seqnames2, score = runif(5)*100, gc = runif(5))
gi

####################################################################
# 1. Arrange GInteractions by a numerical column
####################################################################

gi |> arrange(gc)

####################################################################
# 2. Arrange GInteractions by a logical column
####################################################################

gi |> arrange(cis)

####################################################################
# 3. Arrange GInteractions by a factor
####################################################################

gi |> 
  mutate(rep = factor(c("rep1", "rep2", "rep1", "rep2", "rep1"))) |> 
  arrange(rep)

####################################################################
# 4. Combine sorting variables
####################################################################

gi |> 
  mutate(rep = factor(c("rep1", "rep2", "rep1", "rep2", "rep1"))) |> 
  arrange(dplyr::desc(rep), score)

}
