% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readHic.R
\name{readHic}
\alias{readHic}
\title{Read a .hic file and return Hi-C data as a dataframe}
\usage{
readHic(
    file,
    chrom,
    chromstart = NULL,
    chromend = NULL,
    altchrom = NULL,
    altchromstart = NULL,
    altchromend = NULL,
    assembly = "hg38",
    resolution = "auto",
    res_scale = "BP",
    zrange = NULL,
    norm = "KR",
    matrix = "observed",
    params = NULL,
    quiet = FALSE
)
}
\arguments{
\item{file}{A character value specifying the path to the .hic file.}

\item{chrom}{Chromosome of data, as a string.}

\item{chromstart}{Integer start position on chromosome.}

\item{chromend}{Integer end position on chromosome.}

\item{altchrom}{Alternate chromosome for interchromosomal data,
as a string.}

\item{altchromstart}{Alternate chromosome integer start position
for interchromosomal data.}

\item{altchromend}{Alternate chromosome integer end position
for interchromosomal data.}

\item{assembly}{Default genome assembly as a string or a
\link[plotgardener]{assembly} object.
Default value is \code{assembly = "hg38"}.}

\item{resolution}{A numeric specifying the width of each pixel.
"auto" will attempt to choose a resolution in basepairs based on
the size of the region.}

\item{res_scale}{A character value specifying the resolution scale.
Default value is \code{res_scale = "BP"}. Options are:
\itemize{
\item{\code{"BP"}: }{Base pairs.}
\item{\code{"FRAG"}: }{Fragments.}
}}

\item{zrange}{A numeric vector of length 2 specifying the range of
interaction scores, where extreme values will be set to the max or min.}

\item{norm}{Character value specifying hic data normalization method.
This value must be found in the .hic file.
Default value is \code{norm = "KR"}.}

\item{matrix}{Character value indicating the type of matrix to output.
Default value is \code{matrix = "observed"}. Options are:
\itemize{
\item{\code{"observed"}: }{Observed counts.}
\item{\code{"oe"}: }{Observed/expected counts.}
\item{\code{"log2oe"}: }{Log2 transformed observed/expected counts.}
}}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{quiet}{A logical indicating whether or not to print messages.}
}
\value{
Returns a 3-column dataframe in sparse upper triangular
format with the following columns: \code{chrom}, \code{altchrom},
\code{counts}.
}
\description{
Read a .hic file and return Hi-C data as a dataframe
}
\examples{
hicFile <- system.file("extdata/test_chr22.hic", package="plotgardenerData")

## Read in data for all chr22 file at 2.5Mb bp resolution
hicData <- readHic(file = hicFile, chrom = "22",
                    assembly = "hg19",
                    resolution = 2500000) 
                        
## Read in region `chr22:20000000-47500000` at 100 Kb resolution
hicData10Kb <- readHic(file = hicFile, chrom = "22",
                        chromstart = 20000000, chromend = 47500000,
                        assembly = "hg19",
                        resolution = 100000)                     

}
\seealso{
\link[strawr]{straw}
}
