% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSegments.R
\name{plotSegments}
\alias{plotSegments}
\title{Draw a line segment within a plotgardener layout}
\usage{
plotSegments(
    x0,
    y0,
    x1,
    y1,
    default.units = "inches",
    linecolor = "black",
    lwd = 1,
    lty = 1,
    lineend = "butt",
    linejoin = "mitre",
    arrow = NULL,
    params = NULL,
    ...
)
}
\arguments{
\item{x0}{A numeric vector or unit object indicating the
starting x-values of the line segments.}

\item{y0}{A numeric vector, unit object, or a character vector
of values containing a "b" combined with a numeric value specifying
starting y-values of the line segments.
The character vector will place starting y-values relative to the
bottom of the most recently plotted plot according to the
units of the plotgardener page.}

\item{x1}{A numeric vector or unit object indicating the stopping
x-values of the line segments.}

\item{y1}{A numeric vector, unit object, or a character vector of v
alues containing a "b" combined with a numeric value specifying
stopping y-values of the line segments.
The character vector will place stopping y-values relative to the
bottom of the most recently plotted plot according to the
units of the plotgardener page.}

\item{default.units}{A string indicating the default units to use
if \code{x0}, \code{y0}, \code{x1}, or \code{y1} are only given as
numeric vectors. Default value is \code{default.units = "inches"}.}

\item{linecolor}{A character value specifying segment line color.
Default value is \code{linecolor = "black"}.}

\item{lwd}{A numeric specifying segment line width.
Default value is \code{lwd = 1}.}

\item{lty}{A numeric specifying segment line type.
Default value is \code{lty = 1}.}

\item{lineend}{A character value specifying line end style.
Default value is \code{lineend = "butt"}. Options are:
\itemize{
\item{\code{"round"}: Segment ends are rounded.}
\item{\code{"butt"}: Segment ends end exactly where ended.}
\item{\code{"square"}: Segment ends are squared.}
}}

\item{linejoin}{A character value specifying line join style.
Default value is \code{linejoin = "mitre"}. Options are:
\itemize{
\item{\code{"round"}: }{Line joins are rounded.}
\item{\code{"mitre"}: }{Line joins are sharp corners.}
\item{\code{"bevel"}: }{Line joins are flattened corners.}
}}

\item{arrow}{A list describing arrow heads to place at either end of
the line segments, as produced by the \link[grid]{arrow} function.}

\item{params}{An optional \link[plotgardener]{pgParams} object containing
relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{segments} object containing relevant
placement and \link[grid]{grob} information.
}
\description{
Draw a line segment within a plotgardener layout
}
\examples{
library(grid)
## Create a page
pageCreate(width = 7.5, height = 6, default.units = "inches")

## Plot one line segment
plotSegments(
    x0 = 3.75, y0 = 0.25, x1 = 3.75, y1 = 5.75,
    default.units = "inches",
    lwd = 3, lty = 2
)

## Plot multiple line segments at different locations in different colors
plotSegments(
    x0 = 0.5, y0 = c(1, 3, 5), x1 = 3.25, y1 = c(1, 3, 5),
    default.units = "inches",
    lwd = 2, linecolor = c("#7ecdbb", "#37a7db", "grey")
)

## Plot a line segment with an arrowhead
plotSegments(
    x0 = 4.5, y0 = 0.5, x1 = 7, y1 = 3,
    default.units = "inches",
    arrow = arrow(type = "closed"), fill = "black"
)

## Plot lines with round lineends
plotSegments(
    x0 = c(4, 7), y0 = 3.5, x1 = 5.5, y1 = 4.5,
    default.units = "inches",
    lwd = 5, lineend = "round"
)

## Hide page guides
pageGuideHide()
}
\seealso{
\link[grid]{grid.segments}, \link[grid]{arrow}
}
