% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRaster.R
\name{plotRaster}
\alias{plotRaster}
\title{Plot a raster object within a plotgardener layout}
\usage{
plotRaster(
    image,
    x,
    y,
    width,
    height,
    just = "center",
    default.units = "inches",
    interpolate = TRUE,
    params = NULL,
    ...
)
}
\arguments{
\item{image}{Any R object that can be coerced to a raster object.}

\item{x}{A numeric vector or unit object specifying raster x-locations.}

\item{y}{A numeric vector, unit object, or a character vector of values
containing a "b" combined with a numeric value specifying
raster y-locations.
The character vector will place raster y relative to the bottom
of the most recently plotted plot according to the units
of the plotgardener page.}

\item{width}{A numeric vector or unit object specifying raster widths.}

\item{height}{A numeric vector or unit object specifying raster heights.}

\item{just}{Justification of text relative to its (x, y) location.
If there are two values, the first value specifies horizontal
justification and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and
\code{"top"}. Default value is \code{just = "center"}.}

\item{default.units}{A string indicating the default units
to use if \code{x}, \code{y}, \code{width}, or \code{height}
are only given as numerics or numeric vectors.
Default value is \code{default.units = "inches"}.}

\item{interpolate}{A logical value indicating whether to linearly
interpolate the image. Default value is \code{interpolate = TRUE}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{raster} object containing
relevant placement and \link[grid]{grob} information.
}
\description{
Plot a raster object within a plotgardener layout
}
\examples{
library(png)

## Load images

pg_type <- readPNG(system.file("images",
    "pg-wordmark.png",
    package = "plotgardener"
))

gene_gnome <- readPNG(system.file("images",
    "pg-gnome-hole-shadow.png",
    package = "plotgardener"
))

rlogo <- readPNG(system.file("images", "Rlogo.png", 
                package = "plotgardener"))

## Create page
pageCreate(width = 5, height = 6)

## Plot images
plotRaster(
    image = pg_type,
    x = 2.5, y = 0.25, width = 4, height = 1.5,
    just = "top"
)

plotRaster(
    image = gene_gnome,
    x = 2.5, y = 2.25, width = 3.5, height = 3.5,
    just = "top"
)

plotRaster(
    image = rlogo,
    x = 1, y = 1.5, width = 0.5, height = 0.45,
    just = c("left", "top")
)

## Hide page guies
pageGuideHide()
}
\seealso{
\link[grid]{grid.raster}
}
