% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPairsArches.R
\name{plotPairsArches}
\alias{plotPairsArches}
\title{Plot paired-end genomic range data in an arch style}
\usage{
plotPairsArches(
    data,
    chrom,
    chromstart = NULL,
    chromend = NULL,
    assembly = "hg38",
    style = "2D",
    flip = FALSE,
    curvature = 5,
    archHeight = NULL,
    fill = "#1f4297",
    linecolor = NA,
    alpha = 0.4,
    bg = NA,
    clip = FALSE,
    clip.noAnchor = TRUE,
    range = NULL,
    baseline = FALSE,
    baseline.color = "grey",
    baseline.lwd = 1,
    x = NULL,
    y = NULL,
    width = NULL,
    height = NULL,
    just = c("left", "top"),
    default.units = "inches",
    draw = TRUE,
    params = NULL,
    ...
)
}
\arguments{
\item{data}{A string specifying the BEDPE file path, a dataframe
in BEDPE format specifying data to be plotted, or a
\link[InteractionSet]{GInteractions} object.}

\item{chrom}{Chromosome of region to be plotted, as a string.}

\item{chromstart}{Integer start position on chromosome to be plotted.}

\item{chromend}{Integer end position on chromosome to be plotted.}

\item{assembly}{Default genome assembly as a string or a
\link[plotgardener]{assembly} object.
Default value is \code{assembly = "hg38"}.}

\item{style}{Character value describing the style of arches.
Default value is \code{style = "2D"}. Options are:
\itemize{
\item{\code{"2D"}: }{Arches will be drawn in a 2-dimensional style.}
\item{\code{"3D"}: }{Arches will be drawn in a 3-dimensional style.}
}}

\item{flip}{Logical value indicating whether to reflect arches over
the x-axis. Default value is \code{flip = FALSE}.}

\item{curvature}{Numeric indicating the number of points along the
arch curvature. Default value is \code{curvature = 5}.}

\item{archHeight}{Single numeric value, numeric vector, or column name 
in data specifying the arch heights. When NULL, all arches will be the 
same height, filling up the given plot area.}

\item{fill}{A single character value, a vector, or a 
\link[plotgardener]{colorby} object specifying fill colors of arches.
Default value is \code{fill = #1f4297"}.}

\item{linecolor}{A single character value, a vector, or a
\link[plotgardener]{colorby} object specifying the color of the lines
outlining arches. Default value is \code{linecolor = NA}.
Special options include:
\itemize{
\item{\code{NA}: }{No line color.}
\item{\code{"fill"}: }{Same color as \code{fill}.}
}}

\item{alpha}{Numeric value specifying transparency.
Default value is \code{alpha = 0.4}.}

\item{bg}{Character value indicating background color.
Default value is \code{bg = NA}.}

\item{clip}{A logical value indicating whether to clip any
arches that get cutoff in the given genomic region.
Default value is \code{clip = FALSE}.}

\item{clip.noAnchor}{A logical value indicating whether to clip
any arches that overlap the given genomic region but do not 
have an anchor in that region. Default value is \code{clip.noAnchor = TRUE}.}

\item{range}{A numeric vector of length 2 specifying the y-range
of \code{archHeight} to plot (c(min, max)).}

\item{baseline}{Logical value indicating whether to include
a baseline along the x-axis. Default value is \code{baseline = FALSE}.}

\item{baseline.color}{Baseline color.
Default value is \code{baseline.color = "grey"}.}

\item{baseline.lwd}{Baseline line width.
Default value is \code{baseline.lwd = 1}.}

\item{x}{A numeric or unit object specifying pair arches plot x-location.}

\item{y}{A numeric, unit object, or character containing a "b"
combined with a numeric value specifying BEDPE arches plot y-location.
The character value will
place the pair arches plot y relative to the bottom of the most
recently plotted plot according to the units of the plotgardener page.}

\item{width}{A numeric or unit object specifying pair arches plot width.}

\item{height}{A numeric or unit object specifying pair arches plot height.}

\item{just}{Justification of pair arches plot relative to its (x, y)
location. If there are two values, the first value specifies horizontal
justification and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use if
\code{x}, \code{y}, \code{width}, or \code{height} are only given as
numerics. Default value is \code{default.units = "inches"}.}

\item{draw}{A logical value indicating whether graphics output should be
produced. Default value is \code{draw = TRUE}.}

\item{params}{An optional \link[plotgardener]{pgParams} object containing
relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{arches} object containing relevant
genomic region, placement, and \link[grid]{grob} information.
}
\description{
Plot paired-end genomic range data in an arch style
}
\details{
A pair arches plot can be placed on a plotgardener coordinate page
by providing plot placement parameters:
\preformatted{
plotPairsArches(data chrom,
                chromstart = NULL, chromend = NULL,
                x, y, width, height, just = c("left", "top"),
                default.units = "inches")
}
This function can also be used to quickly plot an unannotated pair
arches plot by ignoring plot placement parameters:
\preformatted{
plotPairsArches(data, chrom,
                chromstart = NULL, chromend = NULL)
}
}
\examples{
## Load paired ranges data in BEDPE format
library(plotgardenerData)
data("IMR90_DNAloops_pairs")

## Set the coordinates
params <- pgParams(
    chrom = "chr21",
    chromstart = 27900000, chromend = 30700000,
    assembly = "hg19",
    width = 7
)

## Create a page
pageCreate(width = 7.5, height = 2.1, default.units = "inches")

## Add a length column to color by
IMR90_DNAloops_pairs$length <- 
        (IMR90_DNAloops_pairs$start2 - IMR90_DNAloops_pairs$start1) / 1000

## Translate lengths into heights
IMR90_DNAloops_pairs$h <- 
        IMR90_DNAloops_pairs$length / max(IMR90_DNAloops_pairs$length)

## Plot the data
archPlot <- plotPairsArches(
    data = IMR90_DNAloops_pairs, params = params,
    fill = colorby("length", palette = 
                colorRampPalette(c("dodgerblue2", "firebrick2"))),
    linecolor = "fill",
    archHeight = "h", alpha = 1,
    x = 0.25, y = 0.25, height = 1.5,
    just = c("left", "top"),
    default.units = "inches"
)

## Annotate genome label
annoGenomeLabel(plot = archPlot, x = 0.25, y = 1.78, scale = "Mb")


## Annotate heatmap legend
annoHeatmapLegend(
    plot = archPlot, fontcolor = "black",
    x = 7.0, y = 0.25,
    width = 0.10, height = 1, fontsize = 10
)

## Add the heatmap legend title
plotText(
    label = "Kb", rot = 90, x = 6.9, y = 0.75,
    just = c("center", "center"),
    fontsize = 10
)


## Hide page guides
pageGuideHide()
}
