% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLegend.R
\name{plotLegend}
\alias{plotLegend}
\title{Plot a legend}
\usage{
plotLegend(
    legend,
    fill = NULL,
    pch = NULL,
    lty = NULL,
    orientation = "v",
    title = NULL,
    fontsize = 10,
    border = TRUE,
    bg = NA,
    x = NULL,
    y = NULL,
    width = NULL,
    height = NULL,
    just = c("left", "top"),
    default.units = "inches",
    draw = TRUE,
    params = NULL,
    ...
)
}
\arguments{
\item{legend}{A character or expression vector to appear in the legend.}

\item{fill}{If specified, this argument will produce boxes filled with
the specified colors to appear beside the legend text.}

\item{pch}{The plotting symbols appearing in the legend, as a
numeric vector.}

\item{lty}{The line types for lines appearing in the legend.}

\item{orientation}{A string specifying legend orientation.
Default value is \code{orientation = "v"}. Options are:
\itemize{
\item{\code{"v"}: }{Vertical legend orientation.}
\item{\code{"h"}: }{Horizontal legend orientation.}
}}

\item{title}{A character value giving a title to be placed at
the top of the legend.}

\item{fontsize}{A numeric specifying text fontsize in points.
Default value is \code{fontsize = 10}.}

\item{border}{Logical value indicating whether to add a border
around heatmap legend. Default value is \code{border = TRUE}.}

\item{bg}{Character value indicating background color.
Default value is \code{bg = NA}.}

\item{x}{A numeric or unit object specifying legend x-location.}

\item{y}{A numeric, unit object, or character containing a "b"
combined with a numeric value specifying legend y-location.
The character value will
place the legend y relative to the bottom of the most recently
plotted plot according to the units of the plotgardener page.}

\item{width}{A numeric or unit object specifying legend width.}

\item{height}{A numeric or unit object specifying legend height.}

\item{just}{Justification of legend relative to its (x, y) location.
If there are two values, the first value specifies horizontal
justification and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use
if \code{x}, \code{y}, \code{width}, or \code{height} are only given
as numerics. Default value is \code{default.units = "inches"}.}

\item{draw}{A logical value indicating whether graphics output should
be produced. Default value is \code{draw = TRUE}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{legend} object containing relevant
placement and \link[grid]{grob} information.
}
\description{
Plot a legend
}
\examples{
## Load BED data
library(plotgardenerData)
data("IMR90_ChIP_CTCF_reads")

## Create page
pageCreate(width = 7.5, height = 4, default.units = "inches")

## Plot a pileup plot, coloring elements by strand
pileupPlot <- plotRanges(
    data = IMR90_ChIP_CTCF_reads, chrom = "chr21",
    chromstart = 29072500, chromend = 29075000,
    assembly = "hg19",
    fill = colorby("strand", palette = 
                colorRampPalette(c("steel blue", "light salmon"))),
    x = 0.5, y = 3.5, width = 6.5, height = 3.5,
    just = c("left", "bottom"),
    default.units = "inches"
)

## Add a legend depicting strand colors
legendPlot <- plotLegend(
    legend = c("- strand", "+ strand"),
    fill = c("steel blue", "light salmon"),
    border = FALSE,
    x = 5, y = 0.5, width = 1.5, height = 0.7,
    just = c("left", "top"),
    default.units = "inches"
)

## Annotate genome label
annoGenomeLabel(
    plot = pileupPlot, x = 0.5, y = 3.5,
    just = c("left", "top")
)

## Hide page guides
pageGuideHide()
}
