% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pageLayout.R
\name{pageLayoutCol}
\alias{pageLayoutCol}
\title{Generate column positions for a number of plot elements with a specified 
width and space between them}
\usage{
pageLayoutCol(x, width, space, n, default.units = "inches")
}
\arguments{
\item{x}{A numeric or unit object specifying the starting column x-position.}

\item{width}{A numeric or unit object specifying the width of columns.}

\item{space}{A numeric or unit object specifying the space between columns.}

\item{n}{An integer specifying the number of elements to generate column 
positions for.}

\item{default.units}{A string indicating the default units to use
if \code{x}, \code{w}, or \code{s} are only given as numerics.
Default value is \code{default.units = "inches"}}
}
\value{
Returns a unit vector of page positions.
}
\description{
Generate column positions for a number of plot elements with a specified 
width and space between them
}
\examples{
# Starting at 0.5 units, return a vector of positions for 3 objects that
# are 2 units in width with 0.1 units of space between them

pageLayoutCol(x = 0.5, width = 2, space = 0.1, n = 3, 
            default.units = "inches")

}
