% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pageCreate.R
\name{pageCreate}
\alias{pageCreate}
\title{Create a page for a plotgardener layout}
\usage{
pageCreate(
    width = 8.5,
    height = 11,
    default.units = "inches",
    bg = NA,
    xgrid = 0.5,
    ygrid = 0.5,
    showGuides = TRUE,
    params = NULL
)
}
\arguments{
\item{width}{A numeric or unit object specifying page width.
Default value is \code{width = 8}.}

\item{height}{A numeric or unit object specifying page height.
Default value is \code{height = 11}.}

\item{default.units}{A string indicating the default units to use if
\code{width} or \code{height} are only given as numerics.
Default value is \code{default.units = "inches"}.}

\item{bg}{Character value indicating page background color.
Default value is \code{bg = NA}.}

\item{xgrid}{A numeric indicating the increment by which to place
vertical gridlines. Default value is \code{xgrid = 0.5}.}

\item{ygrid}{A numeric indicating the increment by which to place
horizontal gridlines. Default value is \code{ygrid = 0.5}.}

\item{showGuides}{A logical value indicating whether to draw a
black border around the entire page and guiding rulers along the top and
left side of the page. Default value is \code{showOutline = TRUE}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}
}
\value{
None.
}
\description{
Create a page for a plotgardener layout
}
\details{
\code{width} and \code{height} must be specified in the same units.
}
\examples{
## Create a 6-inch wide, 4.5-inch high page
pageCreate(width = 6, height = 4.5, default.units = "inches")

## Create a 14-cm wide, 10-cm high page
pageCreate(width = 14, height = 10, default.units = "cm")
}
