% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoText.R
\name{annoText}
\alias{annoText}
\title{Annotates text within a plot}
\usage{
annoText(
    label,
    fontcolor = "black",
    fontsize = 12,
    rot = 0,
    check.overlap = FALSE,
    plot,
    x,
    y,
    just = "center",
    default.units = "native",
    params = NULL,
    ...
)
}
\arguments{
\item{label}{Character or expression of text to be plotted.}

\item{fontcolor}{A character value specifying text fontcolor.
Default value is \code{fontcolor = "black"}.}

\item{fontsize}{A numeric specifying text fontsize in points.
Default value is \code{fontsize = 12}.}

\item{rot}{A numeric specifying the angle to rotate the text.
Default value is \code{rot = 0}.}

\item{check.overlap}{A logical value to indicate whether to check for
and omit overlapping text. Default value is \code{check.overlap = FALSE}.}

\item{plot}{Input plotgardener plot to internally place text relative to.}

\item{x}{A numeric vector or unit object specifying text x-location.}

\item{y}{A numeric vector or unit object specifying text y-location.}

\item{just}{Justification of text relative to its (x, y) location.
If there are two values, the first value specifies horizontal
justification and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = "center"}.}

\item{default.units}{A string indicating the default units to use if
\code{x} or \code{y} are only given as numerics or numeric vectors.
Default value is \code{default.units = "native"}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{text} object containing
relevant placement and \link[grid]{grob} information.
}
\description{
Annotates text within a plot
}
\examples{
## Create a page
pageCreate(width = 4, height = 4, default.units = "inches")

## Plot text relative to a plotgardener plot
library(plotgardenerData)
data("IMR90_HiC_10kb")
hicPlot <- plotHicSquare(
    data = IMR90_HiC_10kb, chrom = "chr21",
    chromstart = 28000000, chromend = 29500000,
    assembly = "hg19",
    zrange = c(0, 70),
    x = 0.5, y = 0.5, width = 3, height = 3,
    just = c("left", "top"),
    default.units = "inches"
)
annoGenomeLabel(
    plot = hicPlot, x = 0.5, y = 3.55, scale = "Mb",
    just = c("left", "top"), default.units = "inches"
)

annoText(
    label = "Loop", fontsize = 8, plot = hicPlot,
    x = 29075000, y = 28150000,
    just = "center", default.units = "native"
)

## Hide page guides
pageGuideHide()
}
\seealso{
\link[grid]{grid.text}
}
