% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoPixels.R
\name{annoPixels}
\alias{annoPixels}
\title{Annotate pixels in a Hi-C plot}
\usage{
annoPixels(
    plot,
    data,
    type = "box",
    half = "inherit",
    shift = 4,
    params = NULL,
    quiet = FALSE,
    ...
)
}
\arguments{
\item{plot}{Hi-C plot object from \code{plotHicSquare} or
\code{plotHicTriangle} on which to annotate pixels.}

\item{data}{A string specifying the BEDPE file path, a dataframe in BEDPE
format specifying pixel positions, or a
\link[InteractionSet]{GInteractions} object specifying pixel
positions.}

\item{type}{Character value specifying type of annotation.
Default value is \code{type = "box"}. Options are:
\itemize{
\item{\code{"box"}: }{Boxes are drawn around each pixel.}
\item{\code{"circle"}: }{Circles are drawn around each pixel.}
\item{\code{"arrow"}: }{Arrows are drawn pointing to each pixel.}
}}

\item{half}{Character value specifying which half of hic plots
to annotate. Triangle Hi-C plots will always default to the entirety of
the triangular plot. Default value is \code{half = "inherit"}. Options are:
\itemize{
\item{\code{"inherit"}: }{Pixels will be annotated on the \code{half}
inherited by the input Hi-C plot.}
\item{\code{"both"}: }{Pixels will be annotated on both halves of the
diagonal of a square Hi-C plot.}
\item{\code{"top"}: }{Pixels will be annotated on the upper diagonal
half of a square Hi-C plot.}
\item{\code{"bottom"}: }{Pixels will be annotated on the bottom diagonal
half of a square Hi-C plot.}
}}

\item{shift}{Numeric specifying the number of pixels on either end of
main pixel in a box or circle. Numeric specifying number of pixels
for the length of an arrow.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{quiet}{A logical indicating whether or not to print messages.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{pixel} object containing relevant
genomic region, placement, and \link[grid]{grob} information.
}
\description{
Annotate pixels in a Hi-C plot
}
\examples{
## Load Hi-C data and BEDPE data
library(plotgardenerData)
data("IMR90_HiC_10kb")
data("IMR90_DNAloops_pairs")

## Create page
pageCreate(width = 4.5, height = 4, default.units = "inches")

## Plot and place a square Hi-C plot
hicPlot <- plotHicSquare(
    data = IMR90_HiC_10kb, resolution = 10000,
    zrange = c(0, 70),
    chrom = "chr21",
    chromstart = 28000000, chromend = 30300000,
    assembly = "hg19",
    x = 0.5, y = 0.5, width = 3, height = 3,
    just = c("left", "top"),
    default.units = "inches"
)

## Annotate loops of both sides of Hi-C plot with squares
pixels <- annoPixels(
    plot = hicPlot, data = IMR90_DNAloops_pairs, type = "box",
    half = "both"
)

## Annotate loops on one side of Hi-C plot with arrows
## and the other side with circles
pagePlotRemove(plot = pixels)
pixels1 <- annoPixels(
    plot = hicPlot, data = IMR90_DNAloops_pairs,
    type = "arrow", half = "top", shift = 8
)
pixels2 <- annoPixels(
    plot = hicPlot, data = IMR90_DNAloops_pairs,
    type = "circle", half = "bottom"
)

## Annotate heatmap legend
annoHeatmapLegend(
    plot = hicPlot,
    x = 3.6, y = 0.5, width = 0.12, height = 1.2,
    just = c("left", "top"), default.units = "inches"
)

## Annotate genome label
annoGenomeLabel(
    plot = hicPlot, x = 0.5, y = 3.53, scale = "Mb",
    just = c("left", "top")
)

## Hide page guides
pageGuideHide()
}
